/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.adf.engine.shared.formGeneration.layout;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutSettings;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@Dependent
public class LayoutGenerator {
    public static final int MAX_SPAN = 12;
    private ColSpan[] structure;
    private List<Row> rows = new ArrayList<Row>();
    private Row currentRow;

    public void init(LayoutColumnDefinition[] structure) {
        this.currentRow = null;
        this.rows.clear();
        int autoCount = 0;
        int maxSpan = 0;
        for (LayoutColumnDefinition col : structure) {
            if (col.getSpan().equals((Object)ColSpan.AUTO)) {
                ++autoCount;
                continue;
            }
            maxSpan += col.getSpan().getSpan();
        }
        if (maxSpan > 12) {
            throw new IllegalArgumentException("Max SPAN allowed for all layout columns is 12.");
        }
        if (maxSpan < 12 && autoCount == 0) {
            throw new IllegalArgumentException("Wrong layout definition, the columns total span must be 12");
        }
        if (maxSpan + autoCount > 12) {
            throw new IllegalArgumentException("There's not enough space for all columns in layout.");
        }
        int freeSpan = 12 - maxSpan;
        int freeOffset = 0;
        int freeAVGSpan = 0;
        if (freeSpan > 0) {
            freeOffset = freeSpan % autoCount;
            freeAVGSpan = Math.floorDiv(freeSpan, autoCount);
        }
        ArrayList<ColSpan> spans = new ArrayList<ColSpan>();
        for (LayoutColumnDefinition definition : structure) {
            if (definition.getSpan().equals((Object)ColSpan.AUTO)) {
                int span = freeAVGSpan;
                if (freeOffset > 0) {
                    ++span;
                    --freeOffset;
                }
                spans.add(ColSpan.calculateSpan((int)span));
                continue;
            }
            spans.add(definition.getSpan());
        }
        this.structure = spans.toArray(new ColSpan[spans.size()]);
    }

    public void addComponent(LayoutComponent component, LayoutSettings settings) {
        if (this.currentRow == null || this.currentRow.isFull()) {
            this.newRow();
        }
        if (!this.currentRow.addComponent(component, settings)) {
            this.newRow();
            this.currentRow.addComponent(component, settings);
        }
    }

    public LayoutTemplate build() {
        LayoutTemplate template = new LayoutTemplate();
        this.rows.stream().filter(row -> !row.cells.isEmpty()).forEach(row -> {
            LayoutRow layoutRow = new LayoutRow();
            template.addRow(layoutRow);
            row.cells.forEach(cell -> {
                LayoutColumn layoutColumn = new LayoutColumn(String.valueOf(((Cell)cell).horizontalSpan));
                layoutRow.add(layoutColumn);
                if (((Cell)cell).getComponentsCount() == 0) {
                    return;
                }
                if (((Cell)cell).getComponentsCount() == 1) {
                    layoutColumn.add((LayoutComponent)((Cell)cell).components.get(0));
                } else {
                    ((Cell)cell).components.forEach(component -> {
                        LayoutRow nestedRow = new LayoutRow();
                        layoutColumn.addRow(nestedRow);
                        LayoutColumn nestedColumn = new LayoutColumn(String.valueOf(12));
                        nestedRow.add(nestedColumn);
                        nestedColumn.add(component);
                    });
                }
            });
        });
        return template;
    }

    protected void newRow() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (ColSpan span : this.structure) {
            cells.add(new Cell(span.getSpan()));
        }
        this.currentRow = new Row(cells);
        this.rows.add(this.currentRow);
    }

    private class Cell {
        private int horizontalSpan = 1;
        private int verticalSpan = 1;
        private boolean wrap;
        private List<LayoutComponent> components = new ArrayList<LayoutComponent>();

        public Cell(int horizontalSpan) {
            this.horizontalSpan = horizontalSpan;
        }

        private void addLayoutComponent(LayoutComponent component) {
            this.components.add(component);
        }

        private int getComponentsCount() {
            return this.components.size();
        }

        public int getVerticalSpan() {
            return this.verticalSpan;
        }

        public void setVerticalSpan(int verticalSpan) {
            this.verticalSpan = verticalSpan;
        }
    }

    private class Row {
        List<Cell> cells;
        int currentIndex = 0;

        public Row(List<Cell> cells) {
            this.cells = cells;
        }

        boolean isFull() {
            return this.currentIndex == this.cells.size() || this.currentIndex > 0 && this.cells.get(this.currentIndex - 1).wrap;
        }

        public boolean addComponent(LayoutComponent component, LayoutSettings settings) {
            int horizontalSpan = settings.getHorizontalSpan();
            Cell currentCell = this.cells.get(this.currentIndex);
            currentCell.wrap = settings.isWrap();
            currentCell.addLayoutComponent(component);
            if (horizontalSpan > 1) {
                while (horizontalSpan > 1 && this.cells.size() > this.currentIndex + 1) {
                    Cell cell = this.cells.remove(this.currentIndex + 1);
                    Cell cell2 = currentCell;
                    cell2.horizontalSpan = cell2.horizontalSpan + cell.horizontalSpan;
                }
            }
            ++this.currentIndex;
            return true;
        }
    }
}

