/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.v1_2.TDMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ExternalLink;

class DMNExternalLinksToExtensionElements {
    DMNExternalLinksToExtensionElements() {
    }

    static void loadExternalLinksFromExtensionElements(org.kie.dmn.model.api.DRGElement source, DRGElement target) {
        if (!Objects.isNull(source.getExtensionElements())) {
            for (Object obj : source.getExtensionElements().getAny()) {
                if (!(obj instanceof ExternalLink)) continue;
                ExternalLink el = (ExternalLink)((Object)obj);
                DMNExternalLink external = new DMNExternalLink();
                external.setDescription(el.getName());
                external.setUrl(el.getUrl());
                target.getLinksHolder().getValue().addLink(external);
            }
        }
    }

    static void loadExternalLinksIntoExtensionElements(DRGElement source, org.kie.dmn.model.api.DRGElement target) {
        if (Objects.isNull(source.getLinksHolder()) || Objects.isNull(source.getLinksHolder().getValue())) {
            return;
        }
        DocumentationLinks links = source.getLinksHolder().getValue();
        DMNElement.ExtensionElements elements = DMNExternalLinksToExtensionElements.getOrCreateExtensionElements(target);
        DMNExternalLinksToExtensionElements.removeAllExistingLinks(elements);
        for (DMNExternalLink link : links.getLinks()) {
            ExternalLink external = new ExternalLink();
            external.setName(link.getDescription());
            external.setUrl(link.getUrl());
            elements.getAny().add(external);
        }
        target.setExtensionElements(elements);
    }

    private static void removeAllExistingLinks(DMNElement.ExtensionElements elements) {
        List existing = elements.getAny().stream().filter(obj -> obj instanceof ExternalLink).collect(Collectors.toList());
        elements.getAny().removeAll(existing);
    }

    static DMNElement.ExtensionElements getOrCreateExtensionElements(org.kie.dmn.model.api.DRGElement target) {
        return target.getExtensionElements() == null ? new TDMNElement.TExtensionElements() : target.getExtensionElements();
    }
}

