/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerSettings;

public class DisplayerConstraints {
    protected DataSetLookupConstraints dataSetLookupConstraints;
    protected Set<DisplayerAttributeDef> supportedEditorAttributes;
    protected Set<DisplayerAttributeDef> excludedEditorAttributes;
    protected Set<String> supportedEditorAttrStrings;
    protected boolean supportingComponentAttributes;
    public static final int ERROR_DATASET_LOOKUP_CONSTRAINTS_NOT_FOUND = 301;

    public DisplayerConstraints(DataSetLookupConstraints dataSetLookupConstraints) {
        this.dataSetLookupConstraints = dataSetLookupConstraints;
        this.supportedEditorAttributes = new HashSet<DisplayerAttributeDef>();
        this.supportedEditorAttrStrings = new HashSet<String>();
        this.excludedEditorAttributes = new HashSet<DisplayerAttributeDef>();
    }

    public DisplayerConstraints supportingComponentAttributes(boolean supportingComponentAttributes) {
        this.supportingComponentAttributes = supportingComponentAttributes;
        return this;
    }

    public DisplayerConstraints supportsAttribute(DisplayerAttributeDef attributeDef) {
        if (!this.excludedEditorAttributes.contains(attributeDef)) {
            for (DisplayerAttributeDef _attr = attributeDef; _attr != null; _attr = _attr.getParent()) {
                this.supportedEditorAttributes.add(_attr);
                this.supportedEditorAttrStrings.add(_attr.getFullId());
            }
            if (attributeDef instanceof DisplayerAttributeGroupDef) {
                for (DisplayerAttributeDef member : ((DisplayerAttributeGroupDef)attributeDef).getChildren()) {
                    this.supportsAttribute(member);
                }
            }
        }
        return this;
    }

    public DisplayerConstraints excludeAttribute(DisplayerAttributeDef attributeDef) {
        this.excludedEditorAttributes.add(attributeDef);
        this.supportedEditorAttributes.remove(attributeDef);
        this.supportedEditorAttrStrings.remove(attributeDef.getFullId());
        return this;
    }

    public Set<DisplayerAttributeDef> getSupportedAttributes() {
        return this.supportedEditorAttributes;
    }

    public DataSetLookupConstraints getDataSetLookupConstraints() {
        return this.dataSetLookupConstraints;
    }

    public DisplayerConstraints setDataSetLookupConstraints(DataSetLookupConstraints dataSetLookupConstraints) {
        this.dataSetLookupConstraints = dataSetLookupConstraints;
        return this;
    }

    public void removeUnsupportedAttributes(DisplayerSettings displayerSettings) {
        String componentId = displayerSettings.getComponentId();
        if (componentId != null) {
            Map<String, String> settingsMap = displayerSettings.getSettingsFlatMap();
            for (String setting : new HashSet<String>(settingsMap.keySet())) {
                if (this.supportedEditorAttrStrings.contains(setting) || setting.startsWith(componentId)) continue;
                displayerSettings.removeDisplayerSetting(setting);
            }
        }
    }

    public ValidationError check(DisplayerSettings settings) {
        ValidationError error;
        if (this.dataSetLookupConstraints == null) {
            return this.createValidationError(301);
        }
        if (settings.getDataSet() != null) {
            ValidationError error2 = this.dataSetLookupConstraints.check(settings.getDataSet());
            if (error2 != null) {
                return error2;
            }
        } else if (settings.getDataSetLookup() != null && (error = this.dataSetLookupConstraints.check(settings.getDataSetLookup())) != null) {
            return error;
        }
        return null;
    }

    protected ValidationError createValidationError(int error) {
        switch (error) {
            case 301: {
                return new ValidationError(error, "Missing DataSetLookupContraints instance");
            }
        }
        return new ValidationError(error);
    }
}

