/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view;

import java.util.Map;
import java.util.Objects;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;

public interface HasTitle<T> {
    public T setTextSizeConstraints(Size var1);

    public T setTitlePosition(VerticalAlignment var1, HorizontalAlignment var2, ReferencePosition var3, Orientation var4);

    public T setTitle(String var1);

    public T setMargins(Map<Enum, Double> var1);

    public T setTitleXOffsetPosition(Double var1);

    public T setTitleYOffsetPosition(Double var1);

    public T setTitleRotation(double var1);

    public T setTitleAlpha(double var1);

    public T setTitleFontFamily(String var1);

    public T setTitleFontSize(double var1);

    public T setTitleFontColor(String var1);

    public T setTitleStrokeWidth(double var1);

    public String getTitleFontFamily();

    public double getTitleFontSize();

    public String getTitlePosition();

    public String getOrientation();

    public double getMarginX();

    public String getFontPosition();

    public String getFontAlignment();

    default public T setTitleStrokeAlpha(double alpha) {
        return (T)this;
    }

    default public T setTextWrapper(TextWrapperStrategy strategy) {
        return (T)this;
    }

    public T setTitleStrokeColor(String var1);

    public T moveTitleToTop();

    default public void setTextBoundaries(double width, double height) {
    }

    public static class Size {
        private double height;
        private double width;
        private SizeType type;

        public Size(double width, double height, SizeType type) {
            this.width = width;
            this.height = height;
            this.type = type;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public SizeType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Size size = (Size)o;
            return Double.compare(size.height, this.height) == 0 && Double.compare(size.width, this.width) == 0 && this.type == size.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.height, this.width, this.type});
        }

        public static enum SizeType {
            PERCENTAGE,
            RAW;

        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum ReferencePosition {
        INSIDE,
        OUTSIDE;

    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        RIGHT,
        CENTER,
        LEFT;

    }
}

