/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.backend.service;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.kogito.api.editor.DiagramType;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.editor.ProjectDiagramResource;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;

@Service
@ApplicationScoped
public class ProjectDiagramResourceServiceImpl
implements ProjectDiagramResourceService {
    private final ProjectDiagramService projectDiagramService;
    private final RenameService renameService;
    private final SaveAndRenameServiceImpl<ProjectDiagramResource, Metadata> saveAndRenameService;

    public ProjectDiagramResourceServiceImpl() {
        this(null, null, null);
    }

    @Inject
    public ProjectDiagramResourceServiceImpl(ProjectDiagramService projectDiagramService, RenameService renameService, SaveAndRenameServiceImpl<ProjectDiagramResource, Metadata> saveAndRenameService) {
        this.projectDiagramService = projectDiagramService;
        this.renameService = renameService;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public Path save(Path path, ProjectDiagramResource resource, Metadata metadata, String comment) {
        DiagramType type = resource.getType();
        HashMap<DiagramType, Function<ProjectDiagramResource, Path>> saveOperations = new HashMap<DiagramType, Function<ProjectDiagramResource, Path>>();
        saveOperations.put(DiagramType.PROJECT_DIAGRAM, r -> this.projectDiagramService.save(path, (Object)this.getProjectDiagram((ProjectDiagramResource)r), metadata, comment));
        saveOperations.put(DiagramType.XML_DIAGRAM, r -> this.projectDiagramService.saveAsXml(path, this.getXmlDiagram((ProjectDiagramResource)r), metadata, comment));
        return (Path)((Function)saveOperations.get(type)).apply(resource);
    }

    private ProjectDiagram getProjectDiagram(ProjectDiagramResource resource) {
        String message = "A ProjectDiagramResource with type = " + resource.getType() + " must have a valid projectDiagram.";
        return (ProjectDiagram)resource.projectDiagram().orElseThrow(() -> new IllegalStateException(message));
    }

    private String getXmlDiagram(ProjectDiagramResource resource) {
        String message = "A ProjectDiagramResource with type = " + resource.getType() + " must have a valid xmlDiagram.";
        return (String)resource.xmlDiagram().orElseThrow(() -> new IllegalStateException(message));
    }

    public Path rename(Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public Path saveAndRename(Path path, String newFileName, Metadata metadata, ProjectDiagramResource resource, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)resource, comment);
    }
}

