/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition;

import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;

public interface HasExpression {
    public static final HasExpression NOP = new HasExpression(){

        @Override
        public Expression getExpression() {
            return null;
        }

        @Override
        public void setExpression(Expression expression) {
        }

        @Override
        public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
            return null;
        }
    };

    public Expression getExpression();

    public void setExpression(Expression var1);

    public DMNModelInstrumentedBase asDMNModelInstrumentedBase();

    default public boolean isClearSupported() {
        return true;
    }

    public static HasExpression wrap(DMNModelInstrumentedBase parent, Expression expression) {
        return new WrappedHasExpression(parent, expression);
    }

    @Portable
    public static class WrappedHasExpression
    implements HasExpression {
        private DMNModelInstrumentedBase parent;
        private Expression expression;

        private WrappedHasExpression(@MapsTo(value="parent") DMNModelInstrumentedBase parent, @MapsTo(value="expression") Expression expression) {
            this.parent = Objects.requireNonNull(parent);
            this.expression = expression;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        @Override
        public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
            return this.parent;
        }
    }
}

