/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class FunctionDefinition
extends Expression
implements HasExpression {
    private static final int STATIC_COLUMNS = 2;
    private Expression expression;
    private Kind kind = Kind.FEEL;
    private List<InformationItem> formalParameter;

    public FunctionDefinition() {
        this(new Id(), new Description(), new QName(), null);
    }

    public FunctionDefinition(Id id, Description description, QName typeRef, Expression expression) {
        super(id, description, typeRef);
        this.expression = expression;
    }

    @Override
    public FunctionDefinition copy() {
        FunctionDefinition clonedFunctionDefinition = new FunctionDefinition();
        clonedFunctionDefinition.description = Optional.ofNullable(this.description).map(Description::copy).orElse(null);
        clonedFunctionDefinition.typeRef = Optional.ofNullable(this.typeRef).map(QName::copy).orElse(null);
        clonedFunctionDefinition.componentWidths = new ArrayList(this.componentWidths);
        clonedFunctionDefinition.expression = Optional.ofNullable(this.expression).map(Expression::copy).orElse(null);
        clonedFunctionDefinition.formalParameter = this.cloneFormalParameterList();
        clonedFunctionDefinition.kind = this.kind;
        clonedFunctionDefinition.getAdditionalAttributes().putAll(this.cloneAdditionalAttributes());
        return clonedFunctionDefinition;
    }

    private List<InformationItem> cloneFormalParameterList() {
        return this.getFormalParameter().stream().map(InformationItem::copy).collect(Collectors.toList());
    }

    private Map<QName, String> cloneAdditionalAttributes() {
        return this.getAdditionalAttributes().keySet().stream().map(QName::copy).collect(Collectors.toMap(typeRef -> typeRef, typeRef -> this.getAdditionalAttributes().get(typeRef)));
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        return this;
    }

    public List<InformationItem> getFormalParameter() {
        if (this.formalParameter == null) {
            this.formalParameter = new ArrayList<InformationItem>();
        }
        return this.formalParameter;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Override
    public List<HasTypeRef> getHasTypeRefs() {
        List<HasTypeRef> hasTypeRefs = super.getHasTypeRefs();
        hasTypeRefs.addAll(HasTypeRefHelper.getNotNullHasTypeRefs(this.getExpression()));
        hasTypeRefs.addAll(HasTypeRefHelper.getFlatHasTypeRefs(this.getFormalParameter()));
        return hasTypeRefs;
    }

    @Override
    public int getRequiredComponentWidthCount() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionDefinition)) {
            return false;
        }
        FunctionDefinition that = (FunctionDefinition)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.typeRef != null ? !this.typeRef.equals(that.typeRef) : that.typeRef != null) {
            return false;
        }
        if (this.componentWidths != null ? !this.componentWidths.equals(that.componentWidths) : that.componentWidths != null) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return this.formalParameter != null ? this.formalParameter.equals(that.formalParameter) : that.formalParameter == null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.id != null ? this.id.hashCode() : 0, this.description != null ? this.description.hashCode() : 0, this.typeRef != null ? this.typeRef.hashCode() : 0, this.componentWidths != null ? this.componentWidths.hashCode() : 0, this.expression != null ? this.expression.hashCode() : 0, this.formalParameter != null ? this.formalParameter.hashCode() : 0});
    }

    @Portable
    public static enum Kind {
        FEEL("F", "FEEL"),
        JAVA("J", "Java"),
        PMML("P", "PMML");

        private final String code;
        private final String value;

        private Kind(String code, String value) {
            this.code = code;
            this.value = value;
        }

        public String code() {
            return this.code;
        }

        public static Kind fromValue(String value) {
            for (Kind kind : Kind.values()) {
                if (!Objects.equals(kind.value, value)) continue;
                return kind;
            }
            throw new IllegalArgumentException("FunctionKind [" + value + "] is not supported.");
        }

        public static Kind determineFromString(String code) {
            return code == null ? null : (Objects.equals(Kind.FEEL.code, code) ? FEEL : (Objects.equals(Kind.JAVA.code, code) ? JAVA : (Objects.equals(Kind.PMML.code, code) ? PMML : null)));
        }
    }
}

