/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedRegularFileFilter;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.kie.soup.xstream.XStreamUtils;
import org.kie.workbench.common.screens.explorer.backend.server.FolderListingResolver;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemOperation;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.VFSLockServiceImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.concurrent.Managed;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class ExplorerServiceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorerServiceHelper.class);
    private ExecutorService executorService;
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private LinkedRegularFileFilter regularFileFilter = new LinkedRegularFileFilter((LinkedFilter)this.dotFileFilter);
    private XStream xs = XStreamUtils.createTrustingXStream();
    private KieModuleService moduleService;
    private FolderListingResolver folderListingResolver;
    private IOService ioService;
    private IOService ioServiceConfig;
    private VFSLockServiceImpl lockService;
    private MetadataService metadataService;
    private UserServicesImpl userServices;
    private DeleteService deleteService;
    private RenameService renameService;
    private CopyService copyService;

    public ExplorerServiceHelper() {
    }

    @Inject
    public ExplorerServiceHelper(KieModuleService moduleService, FolderListingResolver folderListingResolver, @Named(value="ioStrategy") IOService ioService, @Named(value="configIO") IOService ioServiceConfig, VFSLockServiceImpl lockService, MetadataService metadataService, UserServicesImpl userServices, DeleteService deleteService, RenameService renameService, CopyService copyService, @Managed ExecutorService executorService) {
        this();
        this.moduleService = moduleService;
        this.folderListingResolver = folderListingResolver;
        this.ioService = ioService;
        this.ioServiceConfig = ioServiceConfig;
        this.lockService = lockService;
        this.metadataService = metadataService;
        this.userServices = userServices;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.copyService = copyService;
        this.executorService = executorService;
    }

    public FolderItem toFolderItem(Package pkg) {
        if (pkg == null) {
            return null;
        }
        return new FolderItem((Object)pkg, pkg.getRelativeCaption(), FolderItemType.FOLDER);
    }

    public FolderItem toFolderItem(Path path) {
        if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE, false, Paths.readLockedBy((org.uberfire.backend.vfs.Path)p), Collections.emptyList(), this.getRestrictedOperations(p));
        }
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER);
        }
        return null;
    }

    public List<FolderItem> getPackageSegments(Package _pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package pkg = _pkg;
        while (pkg != null) {
            Package parent = this.moduleService.resolveParentPackage(pkg);
            if (parent != null) {
                result.add(this.toFolderItem(parent));
            }
            pkg = parent;
        }
        return Lists.reverse(result);
    }

    public FolderListing getFolderListing(FolderItem selectedItem, Module selectedModule, Package selectedPackage, ActiveOptions options) {
        return this.folderListingResolver.resolve(selectedItem, selectedModule, selectedPackage, this, options);
    }

    public FolderListing getFolderListing(Package pkg, ActiveOptions options) {
        return new FolderListing(this.toFolderItem(pkg), this.getItems(pkg, options), this.getPackageSegments(pkg));
    }

    public FolderListing getFolderListing(FolderItem item, ActiveOptions options) {
        FolderListing result = null;
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            result = this.getFolderListing((org.uberfire.backend.vfs.Path)item.getItem(), options);
        } else if (item.getItem() instanceof Package) {
            result = this.getFolderListing((Package)item.getItem(), options);
        }
        return result;
    }

    public FolderListing getFolderListing(org.uberfire.backend.vfs.Path path, ActiveOptions options) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        boolean includeTags = options.contains(Option.SHOW_TAG_FILTER);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        while (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        org.uberfire.backend.vfs.Path basePath = Paths.convert((Path)nioPath);
        DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPath, (DirectoryStream.Filter)this.dotFileFilter);
        for (Path np : nioPaths) {
            FolderItem folderItem;
            org.uberfire.backend.vfs.Path p;
            if (Files.isRegularFile((Path)np, (LinkOption[])new LinkOption[0])) {
                p = Paths.convert((Path)np);
                String lockedBy = Paths.readLockedBy((org.uberfire.backend.vfs.Path)p);
                folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE, false, lockedBy, includeTags ? this.metadataService.getTags(p) : Collections.emptyList(), this.getRestrictedOperations(p));
                folderItems.add(folderItem);
                continue;
            }
            if (!Files.isDirectory((Path)np, (LinkOption[])new LinkOption[0])) continue;
            p = Paths.convert((Path)np);
            boolean lockedItems = !this.lockService.retrieveLockInfos(Paths.convert((Path)np), true).isEmpty();
            folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER, lockedItems, null, Collections.emptyList(), this.getRestrictedOperations(p));
            folderItems.add(folderItem);
        }
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return new FolderListing(this.toFolderItem(nioPath), folderItems, this.getPathSegments(basePath));
    }

    public boolean hasAssets(Package pkg) {
        if (pkg == null) {
            return false;
        }
        if (this.hasAssets(pkg.getPackageMainSrcPath()) || this.hasAssets(pkg.getPackageTestSrcPath()) || this.hasAssets(pkg.getPackageMainResourcesPath()) || this.hasAssets(pkg.getPackageTestResourcesPath())) {
            return true;
        }
        Set childPackages = this.moduleService.resolvePackages(pkg);
        for (Package childPackage : childPackages) {
            if (childPackage.equals((Object)pkg) || !this.hasAssets(childPackage)) continue;
            return true;
        }
        return false;
    }

    boolean hasAssets(org.uberfire.backend.vfs.Path packagePath) {
        DirectoryStream nioPaths;
        Iterator iterator;
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) && (iterator = (nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.regularFileFilter)).iterator()).hasNext()) {
            Path nioPath = (Path)iterator.next();
            return true;
        }
        return false;
    }

    public List<FolderItem> getItems(Package pkg, ActiveOptions options) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        if (pkg == null) {
            return Collections.emptyList();
        }
        Set childPackages = this.moduleService.resolvePackages(pkg);
        for (Package childPackage : childPackages) {
            folderItems.add(this.toFolderItem(childPackage));
        }
        folderItems.addAll(this.getItems(pkg.getPackageMainSrcPath(), options));
        folderItems.addAll(this.getItems(pkg.getPackageTestSrcPath(), options));
        folderItems.addAll(this.getItems(pkg.getPackageMainResourcesPath(), options));
        folderItems.addAll(this.getItems(pkg.getPackageTestResourcesPath(), options));
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return folderItems;
    }

    List<FolderItem> getPathSegments(org.uberfire.backend.vfs.Path path) {
        Path nioSegmentPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        int segmentCount = nioSegmentPath.getNameCount();
        if (segmentCount < 1) {
            return new ArrayList<FolderItem>();
        }
        FolderItem[] segments = new FolderItem[segmentCount];
        for (int idx = segmentCount; idx > 0; --idx) {
            nioSegmentPath = nioSegmentPath.getParent();
            segments[idx - 1] = this.toFolderItem(nioSegmentPath);
        }
        return Arrays.asList(segments);
    }

    private List<FolderItem> getItems(org.uberfire.backend.vfs.Path packagePath, ActiveOptions options) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        boolean includeTags = options.contains(Option.SHOW_TAG_FILTER);
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.regularFileFilter);
            for (Path nioPath : nioPaths) {
                org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioPath);
                if (Paths.isLock((org.uberfire.backend.vfs.Path)path)) continue;
                String lockedBy = Paths.readLockedBy((org.uberfire.backend.vfs.Path)path);
                FolderItem folderItem = new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE, false, lockedBy, includeTags ? this.metadataService.getTags(path) : Collections.emptyList(), this.getRestrictedOperations(path));
                folderItems.add(folderItem);
            }
        }
        return folderItems;
    }

    public void store(final WorkspaceProject project, Module selectedModule, FolderListing folderListing, Package selectedPackage, ActiveOptions options) {
        final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
        final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
        final Module _selectedModule = selectedModule;
        FolderItem _selectedItem = folderListing.getItem();
        Object _selectedPackage = selectedPackage != null ? selectedPackage : (folderListing.getItem().getItem() instanceof Package ? (Package)folderListing.getItem().getItem() : null);
        this.executorService.execute((Runnable)new DescriptiveRunnable((Package)_selectedPackage, _selectedItem, options){
            final /* synthetic */ Package val$_selectedPackage;
            final /* synthetic */ FolderItem val$_selectedItem;
            final /* synthetic */ ActiveOptions val$options;
            {
                this.val$_selectedPackage = package_;
                this.val$_selectedItem = folderItem;
                this.val$options = activeOptions;
            }

            public String getDescription() {
                return "Serialize Navigation State";
            }

            public void run() {
                try {
                    ExplorerServiceHelper.this.store(userNavPath, lastUserNavPath, project, _selectedModule, this.val$_selectedPackage, this.val$_selectedItem, this.val$options);
                }
                catch (Exception e) {
                    LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Path userNav, Path lastUserNav, WorkspaceProject project, Module module, Package pkg, FolderItem item, ActiveOptions options) {
        UserExplorerData _content = this.loadUserContent(userNav);
        UserExplorerData content = _content == null ? new UserExplorerData() : _content;
        UserExplorerLastData lastContent = new UserExplorerLastData();
        if (project != null) {
            content.addRepository(project.getOrganizationalUnit(), project.getRepository());
        }
        if (module != null && project != null) {
            content.addModule(project.getOrganizationalUnit(), project.getRepository(), module);
        }
        if (item != null && project != null && project.getBranch() != null && module != null) {
            lastContent.setFolderItem(project.getRepository(), project.getBranch().getName(), module, item);
            content.addFolderItem(project.getOrganizationalUnit(), project.getRepository(), module, item);
        }
        if (pkg != null && project != null && project.getBranch() != null && module != null) {
            lastContent.setPackage(project.getRepository(), project.getBranch().getName(), module, pkg);
            content.addPackage(project.getOrganizationalUnit(), project.getRepository(), module, pkg);
        }
        if (options != null && !options.isEmpty()) {
            lastContent.setOptions(options);
        }
        if (!content.isEmpty()) {
            try {
                this.ioServiceConfig.startBatch(userNav.getFileSystem());
                this.ioServiceConfig.write(userNav, this.xs.toXML((Object)content), new OpenOption[0]);
                this.ioServiceConfig.write(lastUserNav, this.xs.toXML((Object)lastContent), new OpenOption[0]);
            }
            finally {
                this.ioServiceConfig.endBatch();
            }
        }
    }

    public UserExplorerData loadUserContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public UserExplorerData loadUserContent() {
        UserExplorerData userExplorerData = this.loadUserContent(this.userServices.buildPath("explorer", "user.nav"));
        if (userExplorerData != null) {
            return userExplorerData;
        }
        return new UserExplorerData();
    }

    public UserExplorerLastData getLastContent() {
        try {
            UserExplorerLastData lastData = this.getLastContent(this.userServices.buildPath("explorer", "last.user.nav"));
            if (lastData != null) {
                return lastData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new UserExplorerLastData();
    }

    public UserExplorerLastData getLastContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerLastData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<FolderItemOperation> getRestrictedOperations(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItemOperation> restrictedOperations = new ArrayList<FolderItemOperation>();
        if (this.copyService.hasRestriction(path)) {
            restrictedOperations.add(FolderItemOperation.COPY);
        }
        if (this.renameService.hasRestriction(path)) {
            restrictedOperations.add(FolderItemOperation.RENAME);
        }
        if (this.deleteService.hasRestriction(path)) {
            restrictedOperations.add(FolderItemOperation.DELETE);
        }
        return restrictedOperations;
    }
}

