/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.scorecard.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.scorecard.backend.GuidedScoreCardModelVisitor;
import org.drools.workbench.models.guided.scorecard.backend.GuidedScoreCardXMLPersistence;
import org.drools.workbench.models.guided.scorecard.shared.Attribute;
import org.drools.workbench.models.guided.scorecard.shared.Characteristic;
import org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel;
import org.drools.workbench.screens.guided.scorecard.model.ScoreCardModelContent;
import org.drools.workbench.screens.guided.scorecard.service.GuidedScoreCardEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedScoreCardEditorServiceImpl
extends KieService<ScoreCardModelContent>
implements GuidedScoreCardEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    @Inject
    private SaveAndRenameServiceImpl<ScoreCardModel, Metadata> saveAndRenameService;
    private SafeSessionInfo safeSessionInfo;

    public GuidedScoreCardEditorServiceImpl() {
    }

    @Inject
    public GuidedScoreCardEditorServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, ScoreCardModel content, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, GuidedScoreCardXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ScoreCardModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return GuidedScoreCardXMLPersistence.getInstance().unmarshall(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ScoreCardModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (ScoreCardModelContent)super.loadContent(path);
    }

    protected ScoreCardModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        ScoreCardModel model = this.load(path);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        GuidedScoreCardModelVisitor visitor = new GuidedScoreCardModelVisitor(model);
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, (Set)visitor.getConsumedModelClasses());
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new ScoreCardModelContent(model, overview, dataModel);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ScoreCardModel model, Metadata metadata, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), GuidedScoreCardXMLPersistence.getInstance().marshal(model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, ScoreCardModel model) {
        try {
            List<ValidationMessage> results = this.doValidation(model);
            if (results.isEmpty()) {
                return this.toDRL(path, model);
            }
            return this.toValidationErrors(results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String toDRL(org.uberfire.backend.vfs.Path path, ScoreCardModel model) throws SourceGenerationFailedException {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
    }

    private String toValidationErrors(List<ValidationMessage> results) {
        StringBuilder drl = new StringBuilder();
        for (ValidationMessage msg : results) {
            drl.append("//").append(msg.getText()).append("\n");
        }
        return drl.toString();
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, ScoreCardModel content) {
        try {
            return this.doValidation(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<ValidationMessage> doValidation(ScoreCardModel model) {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        if (this.isBlank(model.getFactName())) {
            results.add(this.makeValidationMessages("Fact Name is empty."));
        }
        if (this.isBlank(model.getFieldName())) {
            results.add(this.makeValidationMessages("Resultant Score Field is empty."));
        }
        if (model.getCharacteristics().size() == 0) {
            results.add(this.makeValidationMessages("No Characteristics Found."));
        }
        int ctr = 1;
        for (Characteristic c : model.getCharacteristics()) {
            String characteristicName = "Characteristic ('#" + ctr + "')";
            if (this.isBlank(c.getName())) {
                results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "' is empty."));
            } else {
                characteristicName = "Characteristic ('" + c.getName() + "')";
            }
            if (this.isBlank(c.getFact())) {
                results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. Fact is empty."));
            }
            if (this.isBlank(c.getField())) {
                results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. Characteristic Field is empty."));
            } else if (this.isBlank(c.getDataType())) {
                results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. Internal Error (missing datatype)."));
            }
            if (c.getAttributes().size() == 0) {
                results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. No Attributes Found."));
            }
            if (model.isUseReasonCodes()) {
                if (this.isBlank(model.getReasonCodeField())) {
                    results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. Resultant Reason Codes Field is empty."));
                }
                if (!"none".equalsIgnoreCase(model.getReasonCodesAlgorithm())) {
                    results.add(this.makeValidationMessages("Characteristic Name '" + characteristicName + "'. Baseline Score is not specified."));
                }
            }
            int attrCtr = 1;
            for (Attribute attribute : c.getAttributes()) {
                String attributeName = "Attribute ('#" + attrCtr + "')";
                if (this.isBlank(attribute.getOperator())) {
                    results.add(this.makeValidationMessages("Attribute Name '" + attributeName + "'. Attribute Operator is empty."));
                }
                if (this.isBlank(attribute.getValue())) {
                    results.add(this.makeValidationMessages("Attribute Name '" + attributeName + "'. Attribute Value is empty."));
                }
                if (model.isUseReasonCodes() && this.isBlank(c.getReasonCode()) && this.isBlank(attribute.getReasonCode())) {
                    results.add(this.makeValidationMessages("Attribute Name '" + attributeName + "'. Reason Code must be set at either attribute or characteristic."));
                }
                ++attrCtr;
            }
            ++ctr;
        }
        return results;
    }

    private boolean isBlank(String str) {
        return str == null || str.isEmpty() || str.trim().isEmpty();
    }

    private ValidationMessage makeValidationMessages(String message) {
        ValidationMessage msg = new ValidationMessage();
        msg.setText(message);
        msg.setLevel(Level.ERROR);
        return msg;
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, ScoreCardModel content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

