/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.uberfire.commons.concurrent.Managed;
import org.uberfire.commons.concurrent.Unmanaged;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class DisposableShutdownService
implements ServletContextListener {
    private ExecutorService unmanagedExecutorService;
    private ExecutorService executorService;

    public DisposableShutdownService() {
    }

    @Inject
    public DisposableShutdownService(@Managed ExecutorService executorService, @Unmanaged ExecutorService unmanagedExecutorService) {
        this.executorService = executorService;
        this.unmanagedExecutorService = unmanagedExecutorService;
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ArrayList<PriorityDisposable> disposables = new ArrayList<PriorityDisposable>(PriorityDisposableRegistry.getDisposables());
        this.sort(disposables);
        for (PriorityDisposable disposable : disposables) {
            disposable.dispose();
        }
        this.executorService.shutdown();
        this.unmanagedExecutorService.shutdown();
        for (FileSystemProvider fileSystemProvider : FileSystemProviders.installedProviders()) {
            if (!(fileSystemProvider instanceof Disposable)) continue;
            ((Disposable)fileSystemProvider).dispose();
        }
        PriorityDisposableRegistry.clear();
    }

    void sort(List<PriorityDisposable> disposables) {
        Collections.sort(disposables, new Comparator<PriorityDisposable>(){

            @Override
            public int compare(PriorityDisposable o1, PriorityDisposable o2) {
                return o2.priority() < o1.priority() ? -1 : (o2.priority() == o1.priority() ? 0 : 1);
            }
        });
    }
}

