/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.shared.preferences;

import java.util.Collections;
import java.util.Map;

public class ApplicationPreferences {
    public static final String DATE_FORMAT = "drools.dateformat";
    public static final String DATE_TIME_FORMAT = "drools.datetimeformat";
    public static final String DEFAULT_LANGUAGE = "drools.defaultlanguage";
    public static final String DEFAULT_COUNTRY = "drools.defaultcountry";
    public static final String KIE_VERSION_PROPERTY_NAME = "kie_version";
    public static final String KIE_PRODUCTIZED = "kie_productized";
    public static final String KIE_TIMEZONE_OFFSET = "kie_timezone_offset";
    public static ApplicationPreferences instance = new ApplicationPreferences(Collections.emptyMap());
    private Map<String, String> preferences = Collections.emptyMap();

    private ApplicationPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public static void setUp(Map<String, String> map) {
        instance = new ApplicationPreferences(map);
    }

    public static boolean getBooleanPref(String name) {
        return Boolean.parseBoolean(ApplicationPreferences.instance.preferences.get(name));
    }

    public static String getStringPref(String name) {
        return ApplicationPreferences.instance.preferences.get(name);
    }

    public static String getDroolsDateFormat() {
        return ApplicationPreferences.getStringPref(DATE_FORMAT);
    }

    public static String getDroolsDateTimeFormat() {
        return ApplicationPreferences.getStringPref(DATE_TIME_FORMAT);
    }

    public static String getCurrentDroolsVersion() {
        return ApplicationPreferences.instance.preferences.get(KIE_VERSION_PROPERTY_NAME);
    }

    public static int getKieTimezoneOffset() {
        return Integer.parseInt(ApplicationPreferences.instance.preferences.get(KIE_TIMEZONE_OFFSET));
    }

    public static boolean isProductized() {
        return Boolean.parseBoolean(ApplicationPreferences.instance.preferences.get(KIE_PRODUCTIZED));
    }
}

