/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractKieContainerService;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioLoader;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.JunitRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioRunnerService;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.kie.api.runtime.KieContainer;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ScenarioRunnerServiceImpl
extends AbstractKieContainerService
implements ScenarioRunnerService {
    @Inject
    private ScenarioLoader scenarioLoader;
    private ScenarioRunnerProvider runnerSupplier = null;

    public List<TestResultMessage> runAllTests(String identifier, Path path) {
        ArrayList<TestResultMessage> testResultMessages = new ArrayList<TestResultMessage>();
        for (Map.Entry<Path, ScenarioSimulationModel> entry : this.scenarioLoader.loadScenarios(path).entrySet()) {
            Simulation simulation = entry.getValue().getSimulation();
            Settings settings = entry.getValue().getSettings();
            if (settings.isSkipFromBuild()) continue;
            testResultMessages.add(this.runTest(identifier, entry.getKey(), simulation.getScesimModelDescriptor(), simulation.getScenarioWithIndex(), settings, entry.getValue().getBackground()).getTestResultMessage());
        }
        return testResultMessages;
    }

    public SimulationRunResult runTest(String identifier, Path path, ScesimModelDescriptor simulationDescriptor, List<ScenarioWithIndex> scenarios, Settings settings, Background background) {
        KieContainer kieContainer = this.getKieContainerClone(path);
        ScenarioRunnerDTO scenarioRunnerDTO = new ScenarioRunnerDTO(simulationDescriptor, scenarios, null, settings, background);
        AbstractScenarioRunner scenarioRunner = this.getOrCreateRunnerSupplier(settings.getType()).create(kieContainer, scenarioRunnerDTO);
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ArrayList<Failure> failureDetails = new ArrayList<Failure>();
        Result result = JunitRunnerHelper.runWithJunit(path, (Runner)scenarioRunner, failures, failureDetails);
        return new SimulationRunResult(scenarios, background.getBackgroundDataWithIndex(), (SimulationRunMetadata)scenarioRunner.getLastRunResultMetadata().orElseThrow(() -> new IllegalStateException("SimulationRunMetadata should be available after a run")), new TestResultMessage(identifier, result.getRunCount(), result.getRunTime(), failures));
    }

    public ScenarioRunnerProvider getOrCreateRunnerSupplier(ScenarioSimulationModel.Type type) {
        if (this.runnerSupplier != null) {
            return this.runnerSupplier;
        }
        return AbstractScenarioRunner.getSpecificRunnerProvider((ScenarioSimulationModel.Type)type);
    }

    public void setRunnerSupplier(ScenarioRunnerProvider runnerSupplier) {
        this.runnerSupplier = runnerSupplier;
    }
}

