/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.github.GithubAuth;
import org.jbpm.process.workitem.github.RepositoryInfo;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubForkRepository.wid", name="GithubForkRepository", displayName="GithubForkRepository", defaultHandler="mvel: new org.jbpm.process.workitem.github.ForkRepositoryWorkitemHandler(\"userName\", \"password\")", documentation="github-workitem/index.html", category="github-workitem", icon="GithubForkRepository.png", parameters={@WidParameter(name="RepoOwner", required=true), @WidParameter(name="RepoName", required=true), @WidParameter(name="Organization")}, results={@WidResult(name="ForkedRepoInfo", runtimeType="org.jbpm.process.workitem.github.RepositoryInfo")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="github-workitem", version="7.46.0.Final")}, serviceInfo=@WidService(category="Github", description="Create Gist or list your repositories in Github", keywords="github,repo,repository,fork", action=@WidAction(title="Fork a GitHub repository"), authinfo=@WidAuth(required=true, params={"userName", "password"}, paramsdescription={"Github username", "Github password"}, referencesite="https://github.com/")))
public class ForkRepositoryWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(ForkRepositoryWorkitemHandler.class);
    private static final String RESULTS_VALUE = "ForkedRepoInfo";

    public ForkRepositoryWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, RepositoryInfo> results = new HashMap<String, RepositoryInfo>();
            String repoOwner = (String)workItem.getParameter("RepoOwner");
            String repoName = (String)workItem.getParameter("RepoName");
            String organization = (String)workItem.getParameter("Organization");
            RepositoryService repoService = this.auth.getRespositoryService(this.userName, this.password);
            RepositoryId toBeForkedRepo = new RepositoryId(repoOwner, repoName);
            Repository forkedRepository = StringUtils.isNotEmpty((CharSequence)organization) ? repoService.forkRepository((IRepositoryIdProvider)toBeForkedRepo, organization) : repoService.forkRepository((IRepositoryIdProvider)toBeForkedRepo);
            results.put(RESULTS_VALUE, new RepositoryInfo(forkedRepository));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

