/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorTextBox;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class TextField
extends AbstractField {
    @Inject
    Event<PropertyEditorChangeEvent> propertyEditorChangeEventEvent;

    @Override
    public Widget widget(PropertyEditorFieldInfo property) {
        PropertyEditorTextBox textBox = (PropertyEditorTextBox)((Object)GWT.create(PropertyEditorTextBox.class));
        textBox.setText(property.getCurrentStringValue());
        textBox.setId(String.valueOf(property.hashCode()));
        this.addEnterKeyHandler(property, textBox);
        this.addLostFocusHandler(property, textBox);
        return textBox;
    }

    private void addLostFocusHandler(final PropertyEditorFieldInfo property, final PropertyEditorTextBox textBox) {
        textBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (TextField.this.validate(property, textBox.getText())) {
                    textBox.clearOldValidationErrors();
                    property.setCurrentStringValue(textBox.getText());
                    TextField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, textBox.getText()));
                } else {
                    textBox.setValidationError(TextField.this.getValidatorErrorMessage(property, textBox.getText()));
                    textBox.setText(property.getCurrentStringValue());
                }
            }
        });
    }

    private void addEnterKeyHandler(final PropertyEditorFieldInfo property, final PropertyEditorTextBox textBox) {
        textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    if (TextField.this.validate(property, textBox.getText())) {
                        textBox.clearOldValidationErrors();
                        property.setCurrentStringValue(textBox.getText());
                        TextField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, textBox.getText()));
                    } else {
                        textBox.setValidationError(TextField.this.getValidatorErrorMessage(property, textBox.getText()));
                        textBox.setText(property.getCurrentStringValue());
                    }
                }
            }
        });
    }
}

