/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama;

import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.processing.layout.AbstractLayoutService;
import org.kie.workbench.common.stunner.core.graph.processing.layout.GraphProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.VertexPositionImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step01.CycleBreaker;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step02.VertexLayerer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VertexOrdering;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.LayerArrangement;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.VertexPositioning;

@Default
public class SugiyamaLayoutService
extends AbstractLayoutService {
    private final CycleBreaker cycleBreaker;
    private final VertexLayerer vertexLayerer;
    private final VertexOrdering vertexOrdering;
    private final VertexPositioning vertexPositioning;
    private final GraphProcessor graphProcessor;
    static final LayerArrangement DEFAULT_LAYER_ARRANGEMENT = LayerArrangement.BottomUp;

    @Inject
    public SugiyamaLayoutService(CycleBreaker cycleBreaker, VertexLayerer vertexLayerer, VertexOrdering vertexOrdering, VertexPositioning vertexPositioning, GraphProcessor graphProcessor) {
        this.cycleBreaker = cycleBreaker;
        this.vertexLayerer = vertexLayerer;
        this.vertexOrdering = vertexOrdering;
        this.vertexPositioning = vertexPositioning;
        this.graphProcessor = graphProcessor;
    }

    @Override
    public Layout createLayout(Graph<?, ?> graph) {
        Iterable nodes = this.graphProcessor.getNodes(graph);
        HashMap<String, Node> indexByUuid = this.createIndex(nodes);
        LayeredGraph layeredGraph = this.createLayeredGraph(indexByUuid.values());
        this.cycleBreaker.breakCycle((ReorderedGraph)layeredGraph);
        this.vertexLayerer.createLayers((ReorderedGraph)layeredGraph);
        this.vertexOrdering.orderVertices((ReorderedGraph)layeredGraph);
        this.vertexPositioning.calculateVerticesPositions((ReorderedGraph)layeredGraph, DEFAULT_LAYER_ARRANGEMENT);
        List<GraphLayer> orderedLayers = layeredGraph.getLayers();
        return this.buildLayout(indexByUuid, orderedLayers);
    }

    HashMap<String, Node> createIndex(Iterable<? extends Node> nodes) {
        HashMap<String, Node> indexByUuid = new HashMap<String, Node>();
        for (Node node : nodes) {
            if (!(node.getContent() instanceof HasBounds)) continue;
            indexByUuid.put(node.getUUID(), node);
        }
        return indexByUuid;
    }

    LayeredGraph createLayeredGraph(Iterable<? extends Node> nodes) {
        LayeredGraph layeredGraph = this.getLayeredGraph();
        for (Node node : nodes) {
            this.addInEdges(layeredGraph, node);
            this.addOutEdges(layeredGraph, node);
        }
        return layeredGraph;
    }

    LayeredGraph getLayeredGraph() {
        return new LayeredGraph();
    }

    void addOutEdges(LayeredGraph layeredGraph, Node n) {
        for (Object e : n.getOutEdges()) {
            if (!(e instanceof Edge)) continue;
            Edge edge = (Edge)e;
            String to = this.getId(edge.getTargetNode());
            String from = this.getId(n);
            layeredGraph.addEdge(from, to);
            layeredGraph.setVertexSize(this.getId(n), this.getWidth(n), this.getHeight(n));
        }
    }

    void addInEdges(LayeredGraph layeredGraph, Node n) {
        for (Object e : n.getInEdges()) {
            if (!(e instanceof Edge)) continue;
            Edge edge = (Edge)e;
            String from = this.getId(edge.getSourceNode());
            String to = this.getId(n);
            layeredGraph.addEdge(from, to);
            layeredGraph.setVertexSize(this.getId(n), this.getWidth(n), this.getHeight(n));
        }
    }

    int getHeight(Node n) {
        return (int)((HasBounds)n.getContent()).getBounds().getHeight();
    }

    int getWidth(Node n) {
        return (int)((HasBounds)n.getContent()).getBounds().getWidth();
    }

    String getId(Node node) {
        if (this.graphProcessor.isReplacedByAnotherNode(node.getUUID())) {
            return this.graphProcessor.getReplaceNodeId(node.getUUID());
        }
        return node.getUUID();
    }

    Layout buildLayout(HashMap<String, Node> indexByUuid, List<GraphLayer> layers) {
        Layout layout = new Layout();
        for (int i = layers.size() - 1; i >= 0; --i) {
            GraphLayer layer = layers.get(i);
            for (Vertex v : layer.getVertices()) {
                Node n = indexByUuid.get(v.getId());
                int x = v.getX();
                int y = v.getY();
                Bounds currentBounds = ((HasBounds)n.getContent()).getBounds();
                Bound lowerRight = currentBounds.getLowerRight();
                int x2 = SugiyamaLayoutService.isCloseToZero(lowerRight.getX()) ? x + 100 : (int)((double)x + lowerRight.getX());
                int y2 = SugiyamaLayoutService.isCloseToZero(lowerRight.getY()) ? y + 50 : (int)((double)y + lowerRight.getY());
                VertexPositionImpl position = new VertexPositionImpl(v.getId(), new Point2D((double)x, (double)y), new Point2D((double)x2, (double)y2));
                layout.getNodePositions().add(position);
            }
        }
        return layout;
    }
}

