/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.processing.layout.OrientedEdgeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.LayerCrossingCount;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VertexLayerPositioning;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VertexOrdering;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VerticesTransposer;

@Default
public final class DefaultVertexOrdering
implements VertexOrdering {
    private final VertexLayerPositioning vertexPositioning;
    private final LayerCrossingCount crossingCount;
    private final VerticesTransposer verticesTransposer;
    private static final int MAX_ITERATIONS = 24;

    @Inject
    public DefaultVertexOrdering(VertexLayerPositioning vertexPositioning, LayerCrossingCount crossingCount, VerticesTransposer verticesTransposer) {
        this.vertexPositioning = vertexPositioning;
        this.crossingCount = crossingCount;
        this.verticesTransposer = verticesTransposer;
    }

    public void orderVertices(ReorderedGraph graph) {
        int i;
        LayeredGraph layered = (LayeredGraph)graph;
        List edges = graph.getEdges();
        List<GraphLayer> virtualized = this.createVirtual(edges, layered);
        List<GraphLayer> best = this.clone(virtualized);
        Object[][] nestedBestRanks = new Object[virtualized.size()][];
        for (i = 0; i < nestedBestRanks.length; ++i) {
            GraphLayer layer = best.get(i);
            nestedBestRanks[i] = new Object[layer.getVertices().size()];
            for (int j = 0; j < layer.getVertices().size(); ++j) {
                nestedBestRanks[i][j] = layer.getVertices().get(j);
            }
        }
        for (i = 0; i < 24; ++i) {
            this.vertexPositioning.positionVertices(virtualized, edges, i);
            this.verticesTransposer.transpose(virtualized, edges, i);
            if (this.crossingCount.crossing(best, edges) <= this.crossingCount.crossing(virtualized, edges)) break;
            best = this.clone(virtualized);
        }
        layered.getLayers().clear();
        layered.getLayers().addAll(best);
    }

    private List<GraphLayer> clone(List<GraphLayer> input) {
        ArrayList<GraphLayer> clone = new ArrayList<GraphLayer>(input.size());
        for (GraphLayer value : input) {
            clone.add(value.clone());
        }
        return clone;
    }

    private List<GraphLayer> createVirtual(List<OrientedEdge> edges, LayeredGraph graph) {
        int virtualIndex = 0;
        List<GraphLayer> virtualized = this.clone(graph.getLayers());
        for (int i = 0; i < virtualized.size() - 1; ++i) {
            GraphLayer currentLayer = virtualized.get(i);
            GraphLayer nextLayer = virtualized.get(i + 1);
            for (Vertex vertex : currentLayer.getVertices()) {
                OrientedEdgeImpl v2;
                OrientedEdgeImpl v1;
                Vertex virtualVertex;
                List outgoing = edges.stream().filter(e -> Objects.equals(e.getFromVertexId(), vertex.getId())).filter(e -> Math.abs(this.getLayerNumber(e.getToVertexId(), virtualized) - this.getLayerNumber(vertex.getId(), virtualized)) > 1).collect(Collectors.toList());
                List incoming = edges.stream().filter(e -> Objects.equals(e.getToVertexId(), vertex.getId())).filter(e -> Math.abs(this.getLayerNumber(e.getFromVertexId(), virtualized) - this.getLayerNumber(vertex.getId(), virtualized)) > 1).collect(Collectors.toList());
                for (OrientedEdge edge : outgoing) {
                    virtualVertex = new Vertex("V" + virtualIndex++, true);
                    nextLayer.getVertices().add(virtualVertex);
                    edges.remove(edge);
                    v1 = new OrientedEdgeImpl(edge.getFromVertexId(), virtualVertex.getId());
                    v2 = new OrientedEdgeImpl(virtualVertex.getId(), edge.getToVertexId());
                    edges.add(v1);
                    edges.add(v2);
                }
                for (OrientedEdge edge : incoming) {
                    virtualVertex = new Vertex("V" + virtualIndex++, true);
                    nextLayer.getVertices().add(virtualVertex);
                    edges.remove(edge);
                    v1 = new OrientedEdgeImpl(virtualVertex.getId(), edge.getToVertexId());
                    v2 = new OrientedEdgeImpl(edge.getFromVertexId(), virtualVertex.getId());
                    edges.add(v1);
                    edges.add(v2);
                }
            }
        }
        return virtualized;
    }

    private int getLayerNumber(String vertex, List<GraphLayer> layers) {
        GraphLayer layer = layers.stream().filter(l -> l.getVertices().stream().anyMatch(v -> Objects.equals(v.getId(), vertex))).findFirst().orElseThrow(() -> new NoSuchElementException("Can not found the layer of the vertex."));
        return layer.getLevel();
    }
}

