/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.rule.violations.EdgeCardinalityMaxRuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.EdgeCardinalityMinRuleViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

@ApplicationScoped
public class EdgeCardinalityEvaluationHandler
implements RuleEvaluationHandler<EdgeOccurrences, EdgeCardinalityContext> {
    public Class<EdgeOccurrences> getRuleType() {
        return EdgeOccurrences.class;
    }

    public Class<EdgeCardinalityContext> getContextType() {
        return EdgeCardinalityContext.class;
    }

    public boolean accepts(EdgeOccurrences rule, EdgeCardinalityContext context) {
        EdgeCardinalityContext.Direction direction = rule.getDirection();
        return context.getEdgeRole().equals(rule.getConnectorRole()) && direction.equals((Object)context.getDirection()) && context.getRoles().contains(rule.getRole());
    }

    public RuleViolations evaluate(EdgeOccurrences rule, EdgeCardinalityContext context) {
        int _count;
        Violation.Type type;
        DefaultRuleViolations results = new DefaultRuleViolations();
        int minOccurrences = rule.getMinOccurrences();
        int maxOccurrences = rule.getMaxOccurrences();
        int candidatesCount = context.getCurrentCount();
        Optional operation = context.getOperation();
        EdgeCardinalityContext.Direction direction = rule.getDirection();
        Violation.Type type2 = type = operation.filter(arg_0 -> CardinalityContext.Operation.ADD.equals(arg_0)).isPresent() ? Violation.Type.ERROR : Violation.Type.WARNING;
        int n = !operation.isPresent() ? candidatesCount : (((CardinalityContext.Operation)operation.get()).equals((Object)CardinalityContext.Operation.ADD) ? candidatesCount + 1 : (_count = candidatesCount > 0 ? candidatesCount - 1 : 0));
        if (_count < minOccurrences) {
            results.addViolation(new EdgeCardinalityMinRuleViolation(context.getRoles().toString(), context.getEdgeRole(), minOccurrences, candidatesCount, direction, type));
        } else if (maxOccurrences > -1 && _count > maxOccurrences) {
            results.addViolation(new EdgeCardinalityMaxRuleViolation(context.getRoles().toString(), context.getEdgeRole(), maxOccurrences, candidatesCount, direction, type));
        }
        return results;
    }
}

