/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collection;
import java.util.Set;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.violations.AbstractGraphViolation;

public class GraphEvaluationHandlerUtils {
    private final DefinitionManager definitionManager;

    public GraphEvaluationHandlerUtils(DefinitionManager definitionManager) {
        this.definitionManager = definitionManager;
    }

    public String getElementDefinitionId(Element<?> element) {
        String targetId = null;
        if (element.getContent() instanceof Definition) {
            Object definition = ((Definition)element.getContent()).getDefinition();
            targetId = this.getDefinitionId(definition);
        } else if (element.getContent() instanceof DefinitionSet) {
            targetId = (String)((DefinitionSet)element.getContent()).getDefinition();
        }
        return targetId;
    }

    public String getDefinitionId(Object definition) {
        return this.definitionManager.adapters().forDefinition().getId(definition).value();
    }

    public Set<String> getLabels(Element<? extends Definition<?>> element) {
        return GraphUtils.getLabels(element);
    }

    public int countEdges(String edgeId, Collection<? extends Edge> edges) {
        return GraphUtils.countEdges(this.definitionManager, edgeId, edges);
    }

    public static RuleViolations addViolationsSourceUUID(String uuid, RuleViolations result) {
        result.violations().forEach(v -> GraphEvaluationHandlerUtils.addViolationSourceUUID(uuid, v));
        return result;
    }

    public static RuleViolation addViolationSourceUUID(String uuid, RuleViolation violation) {
        if (violation instanceof AbstractGraphViolation) {
            ((AbstractGraphViolation)violation).setUUID(uuid);
        }
        return violation;
    }
}

