/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.factory;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNBaseInfo;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.BaseDiagramSet;
import org.kie.workbench.common.stunner.bpmn.util.XmlUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public abstract class AbstractBPMNDiagramFactory<M extends Metadata, D extends Diagram<Graph, M>>
extends BindableDiagramFactory<M, D> {
    private Class<? extends BPMNDiagram> diagramType;
    Function<Graph, Node<Definition<BPMNDiagram>, ?>> diagramProvider = graph -> GraphUtils.getFirstNode((Graph)graph, this.diagramType);

    protected abstract D doBuild(String var1, M var2, Graph<DefinitionSet, ?> var3);

    public void setDiagramType(Class<? extends BPMNDiagram> diagramType) {
        this.diagramType = diagramType;
    }

    public D build(String name, M metadata, Graph<DefinitionSet, ?> graph) {
        String validName = name;
        D diagram = this.doBuild(validName, metadata, graph);
        Node<Definition<BPMNDiagram>, ?> diagramNode = this.diagramProvider.apply(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A BPMN Diagram is expected to be present on BPMN Diagram graphs.");
        }
        this.updateProperties(validName, diagramNode, metadata);
        return diagram;
    }

    protected void updateDiagramProperties(String name, Node<Definition<BPMNDiagram>, ?> diagramNode, M metadata) {
        Optional<BaseDiagramSet> diagramSet = Optional.ofNullable(diagramNode).map(Element::getContent).map(Definition::getDefinition).map(BPMNDiagram::getDiagramSet);
        diagramSet.map(BaseDiagramSet::getId).filter(id -> Objects.isNull(id.getValue())).ifPresent(id -> id.setValue(XmlUtils.createValidId(metadata.getTitle())));
        diagramSet.map(BPMNBaseInfo::getName).filter(attr -> Objects.isNull(attr.getValue())).ifPresent(attr -> attr.setValue(name));
    }

    private void updateProperties(String name, Node<Definition<BPMNDiagram>, ?> diagramNode, M metadata) {
        metadata.setCanvasRootUUID(diagramNode.getUUID());
        this.updateDiagramProperties(name, diagramNode, metadata);
    }

    protected void setDiagramProvider(Function<Graph, Node<Definition<BPMNDiagram>, ?>> diagramProvider) {
        this.diagramProvider = diagramProvider;
    }
}

