/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.DefinitionSet;
import org.kie.workbench.common.stunner.core.definition.annotation.SvgNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReflectDefinitionSetAdapter<T>
extends AbstractReflectAdapter<T>
implements DefinitionSetAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReflectDefinitionSetAdapter.class);

    protected Set<String> getAnnotatedDefinitions(T definitionSet) {
        Class[] definitions;
        DefinitionSet annotation;
        HashSet<String> result = null;
        if (null != definitionSet && null != (annotation = definitionSet.getClass().getAnnotation(DefinitionSet.class)) && (definitions = annotation.definitions()).length > 0) {
            result = new HashSet<String>(definitions.length);
            for (Class defClass : definitions) {
                result.add(BindableAdapterUtils.getDefinitionSetId((Class)defClass));
            }
        }
        return result;
    }

    public String getId(T definitionSet) {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(definitionSet.getClass());
        if (defSetId.contains("$")) {
            defSetId = defSetId.substring(0, defSetId.indexOf("$"));
        }
        return defSetId;
    }

    public String getDomain(T definitionSet) {
        return BindableAdapterUtils.getDefinitionSetDomain(definitionSet.getClass());
    }

    public Optional<String> getSvgNodeId(T definitionSet) {
        try {
            return Optional.ofNullable(this.getAnnotatedFieldValue(definitionSet, SvgNodeId.class));
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated SvgNodeId for DefinitionSet with id " + this.getId(definitionSet));
            return Optional.empty();
        }
    }
}

