/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.table.item;

import com.google.gwt.i18n.client.DateTimeFormat;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.item.model.ArchetypeItem;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.presenters.AbstractArchetypeTablePresenter;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.Archetype;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.ArchetypeStatus;
import org.kie.workbench.common.screens.archetype.mgmt.shared.services.ArchetypeService;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;
import org.kie.workbench.common.widgets.client.widget.ListItemView;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;

@Dependent
public class ArchetypeItemPresenter
extends ListItemPresenter<ArchetypeItem, AbstractArchetypeTablePresenter, View>
implements HasBusyIndicator {
    static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)"MMMM dd, yyyy");
    private final TranslationService ts;
    private final Caller<ArchetypeService> archetypeService;
    private final BusyIndicatorView busyIndicatorView;
    private ArchetypeItem archetypeItem;
    private AbstractArchetypeTablePresenter parentPresenter;

    @Inject
    public ArchetypeItemPresenter(View view, TranslationService ts, Caller<ArchetypeService> archetypeService, BusyIndicatorView busyIndicatorView) {
        super((ListItemView)view);
        this.ts = ts;
        this.archetypeService = archetypeService;
        this.busyIndicatorView = busyIndicatorView;
    }

    public ArchetypeItemPresenter setup(ArchetypeItem archetypeItem, AbstractArchetypeTablePresenter parentPresenter) {
        Archetype archetype = archetypeItem.getArchetype();
        this.archetypeItem = archetypeItem;
        this.parentPresenter = parentPresenter;
        ((View)this.view).init((Object)this);
        ((View)this.view).setIncluded(archetypeItem.isSelected());
        ((View)this.view).setGroupId(archetype.getGav().getGroupId());
        ((View)this.view).setArtifactId(archetype.getGav().getArtifactId());
        ((View)this.view).setVersion(archetype.getGav().getVersion());
        ((View)this.view).setCreatedDate(DATE_FORMAT.format(archetype.getCreatedDate()));
        ((View)this.view).showInclude(parentPresenter.isShowIncludeColumn());
        ((View)this.view).showStatus(parentPresenter.isShowStatusColumn());
        ((View)this.view).showDeleteAction(parentPresenter.isShowDeleteAction());
        ((View)this.view).showValidateAction(parentPresenter.isShowValidateAction());
        ((View)this.view).showDefaultBadge(archetypeItem.isDefaultValue());
        ((View)this.view).enableIncludeCheckbox(this.isValid());
        ((View)this.view).enableSetDefault(this.isValid());
        if (parentPresenter.isShowDeleteAction()) {
            ((View)this.view).setDeleteCommand(this.createDeleteCommand(archetypeItem));
        }
        if (archetypeItem.isDefaultValue()) {
            ((View)this.view).setDefaultBadgeTooltip(this.ts.getTranslation("ArchetypeManagement.DefaultMessage"));
        }
        this.resolveStatus(archetype);
        return this;
    }

    public ArchetypeItem getObject() {
        return this.archetypeItem;
    }

    public void showBusyIndicator(String message) {
        this.busyIndicatorView.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    public void setIncluded(boolean isIncluded) {
        if (this.parentPresenter.canMakeChanges() && this.isValid()) {
            ((View)this.view).checkIncluded(isIncluded);
            this.archetypeItem.setSelected(isIncluded);
            this.parentPresenter.setSelected(this.archetypeItem, isIncluded);
        }
    }

    public void makeDefault() {
        if (this.parentPresenter.canMakeChanges() && this.isValid()) {
            this.setIncluded(true);
            this.parentPresenter.makeDefaultValue(this.archetypeItem.getArchetype().getAlias(), true);
        }
    }

    public void validate() {
        if (this.parentPresenter.canMakeChanges()) {
            this.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
            ((ArchetypeService)this.archetypeService.call(v -> this.hideBusyIndicator(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).validate(this.archetypeItem.getArchetype().getAlias());
        }
    }

    private boolean isValid() {
        return this.archetypeItem.getArchetype().getStatus() == ArchetypeStatus.VALID;
    }

    private void resolveStatus(Archetype archetype) {
        if (archetype.getStatus() == ArchetypeStatus.VALID) {
            ((View)this.view).showValidStatus(true);
            ((View)this.view).showInvalidStatus(false);
            ((View)this.view).setValidTooltip(this.ts.getTranslation("ArchetypeManagement.ValidMessage"));
        } else if (archetype.getStatus() == ArchetypeStatus.INVALID) {
            ((View)this.view).showValidStatus(false);
            ((View)this.view).showInvalidStatus(true);
            ((View)this.view).setInvalidTooltip(this.ts.format("ArchetypeManagement.InvalidMessage", new Object[]{archetype.getMessage()}));
        }
    }

    Command createDeleteCommand(ArchetypeItem item) {
        return () -> {
            if (this.parentPresenter.canMakeChanges()) {
                this.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
                ((ArchetypeService)this.archetypeService.call(v -> this.hideBusyIndicator(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).delete(item.getArchetype().getAlias());
            }
        };
    }

    public static interface View
    extends ListItemView<ArchetypeItemPresenter>,
    IsElement {
        public void showInclude(boolean var1);

        public void showStatus(boolean var1);

        public void setIncluded(boolean var1);

        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public void setCreatedDate(String var1);

        public void showInvalidStatus(boolean var1);

        public void setInvalidTooltip(String var1);

        public void showValidStatus(boolean var1);

        public void setValidTooltip(String var1);

        public void setDeleteCommand(Command var1);

        public void showDeleteAction(boolean var1);

        public void showValidateAction(boolean var1);

        public void showDefaultBadge(boolean var1);

        public void setDefaultBadgeTooltip(String var1);

        public void enableIncludeCheckbox(boolean var1);

        public void enableSetDefault(boolean var1);

        public void checkIncluded(boolean var1);
    }
}

