/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;

public class ParsedReassignmentsInfos {
    ReassignmentValue reassignment = new ReassignmentValue();

    public static ReassignmentValue of(String type, String body) {
        return new ParsedReassignmentsInfos((String)type, (String)body).reassignment;
    }

    public static String ofCDATA(ReassignmentTypeListValue value, AssociationType type) {
        return new CDATA(value, type).get();
    }

    private ParsedReassignmentsInfos(String type, String body) {
        this.reassignment.setType(type);
        if (body != null && !body.isEmpty()) {
            String usersAndGroups;
            if (body.contains("@")) {
                String[] parts = body.split("@");
                ParsedReassignmentsInfos.parsePeriod(this.reassignment, parts[1]);
                usersAndGroups = parts[0];
            } else {
                usersAndGroups = body;
            }
            usersAndGroups = ParsedReassignmentsInfos.replaceBracket(usersAndGroups);
            ParsedReassignmentsInfos.getUsers(this.reassignment, usersAndGroups);
            ParsedReassignmentsInfos.getGroups(this.reassignment, usersAndGroups);
        }
    }

    private static void getUsers(ReassignmentValue reassignment, String usersAndGroups) {
        reassignment.setUsers(ParsedReassignmentsInfos.parseGroup(usersAndGroups, "users", 0));
    }

    private static void getGroups(ReassignmentValue reassignment, String usersAndGroups) {
        reassignment.setGroups(ParsedReassignmentsInfos.parseGroup(usersAndGroups, "groups", 1));
    }

    private static List<String> parseGroup(String group, String type, int position) {
        String result;
        if (group.contains(type) && !(result = group.split("\\|")[position].replace(type + ":", "")).isEmpty()) {
            return Arrays.stream(result.split(",")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static void parsePeriod(ReassignmentValue reassignment, String part) {
        reassignment.setDuration(ParsedReassignmentsInfos.replaceBracket(part));
    }

    private static String replaceBracket(String original) {
        return original.replaceFirst("\\[", "").replace("]", "");
    }

    private static class CDATA {
        private List<ReassignmentValue> reassignments;
        private AssociationType type;

        CDATA(ReassignmentTypeListValue value, AssociationType type) {
            this.type = type;
            this.reassignments = value.getValues();
        }

        String get() {
            return this.reassignments.stream().filter(m -> m.getType().equals(this.type.getName())).map(m -> m.toCDATAFormat()).collect(Collectors.joining("^"));
        }
    }
}

