/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.components.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ProvidedComponentInfo {
    Logger logger = Logger.getLogger(ProvidedComponentInfo.class.getName());
    private static final String DASHBUILDER_COMPONENTS_PROPERTIES = "/dashbuilder-components.properties";
    private static final String DASHBUILDER_COMPONENTS_LIST_PROP = "dashbuilder.internal.components.list";
    private static final String DASHBUILDER_COMPONENTS_ROOT_PROP = "dashbuilder.internal.components.root";
    private static ProvidedComponentInfo instance;
    private List<String> internalComponentsList = Collections.emptyList();
    private String internalComponentsRootPath = null;

    ProvidedComponentInfo() {
    }

    public static ProvidedComponentInfo get() {
        if (instance == null) {
            instance = new ProvidedComponentInfo();
            instance.loadProperties(DASHBUILDER_COMPONENTS_PROPERTIES);
        }
        return instance;
    }

    void loadProperties(String resourcePath) {
        InputStream is = this.getClass().getResourceAsStream(resourcePath);
        if (is == null) {
            this.logger.warning("Not able to find internal components properties file.");
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(is);
            this.loadInternalComponentsList(properties);
            this.loadInternalComponentsRootDir(properties);
        }
        catch (IOException e) {
            this.logger.warning("Not able to load internal components properties file.");
        }
    }

    private void loadInternalComponentsRootDir(Properties properties) {
        this.internalComponentsRootPath = properties.getProperty(DASHBUILDER_COMPONENTS_ROOT_PROP);
        if (this.internalComponentsRootPath == null || this.internalComponentsRootPath.trim().isEmpty()) {
            this.logger.warning("Internal components root not configured.");
        }
    }

    private void loadInternalComponentsList(Properties properties) {
        String componentsListStr = properties.getProperty(DASHBUILDER_COMPONENTS_LIST_PROP);
        if (componentsListStr == null || componentsListStr.trim().isEmpty()) {
            this.logger.warning("Internal components list is empty");
        } else {
            this.internalComponentsList = Arrays.stream(componentsListStr.split("\\,")).collect(Collectors.toList());
            this.logger.log(Level.WARNING, () -> "Registered internal dashbuilder components: " + this.internalComponentsList);
        }
    }

    public List<String> getInternalComponentsList() {
        return this.internalComponentsList;
    }

    public String getInternalComponentsRootPath() {
        return this.internalComponentsRootPath;
    }
}

