/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.backend.config.Repository;
import org.guvnor.structure.backend.config.watch.AsyncConfigWatchService;
import org.guvnor.structure.backend.config.watch.AsyncWatchServiceCallback;
import org.guvnor.structure.backend.config.watch.ConfigServiceWatchServiceExecutor;
import org.guvnor.structure.backend.config.watch.ConfigServiceWatchServiceExecutorImpl;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

@ApplicationScoped
public class ConfigurationServiceImpl
implements ConfigurationService,
AsyncWatchServiceCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    protected static final String MONITOR_DISABLED = "org.uberfire.sys.repo.monitor.disabled";
    protected static final String INVALID_FILENAME_CHARS = "[\\,/,:,*,?,\",<,>,|]";
    protected org.guvnor.structure.repositories.Repository systemRepository;
    protected ConfigGroupMarshaller marshaller;
    protected User identity;
    protected final Map<ConfigType, List<ConfigGroup>> configGroupsByTypeWithoutNamespace = new ConcurrentHashMap<ConfigType, List<ConfigGroup>>();
    protected final Map<ConfigType, Map<String, List<ConfigGroup>>> configGroupsByTypeWithNamespace = new ConcurrentHashMap<ConfigType, Map<String, List<ConfigGroup>>>();
    protected AtomicLong localLastModifiedValue = new AtomicLong(-1L);
    protected IOService ioService;
    protected Event<SystemRepositoryChangedEvent> repoChangedEvent;
    protected Event<SystemRepositoryChangedEvent> spaceChangedEvent;
    protected Event<SystemRepositoryChangedEvent> changedEvent;
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected final Set<Future<?>> jobs = new CopyOnWriteArraySet();
    protected ConfigServiceWatchServiceExecutor executor = null;
    protected CheckConfigurationUpdates configUpdates = null;
    protected WatchService watchService = null;
    protected FileSystem fs;

    public ConfigurationServiceImpl() {
    }

    @Inject
    public ConfigurationServiceImpl(@Named(value="system") org.guvnor.structure.repositories.Repository systemRepository, ConfigGroupMarshaller marshaller, User identity, @Named(value="configIO") IOService ioService, @Repository Event<SystemRepositoryChangedEvent> repoChangedEvent, @OrgUnit Event<SystemRepositoryChangedEvent> spaceChangedEvent, Event<SystemRepositoryChangedEvent> changedEvent, @Named(value="systemFS") FileSystem fs) {
        this.systemRepository = systemRepository;
        this.marshaller = marshaller;
        this.identity = identity;
        this.ioService = ioService;
        this.repoChangedEvent = repoChangedEvent;
        this.spaceChangedEvent = spaceChangedEvent;
        this.changedEvent = changedEvent;
        this.fs = fs;
    }

    @PostConstruct
    public void setup() {
        Path defaultRoot = null;
        for (Path path : this.fs.getRootDirectories()) {
            if (!path.toUri().toString().contains("/master@")) continue;
            defaultRoot = path;
            break;
        }
        if (defaultRoot == null) {
            throw new RuntimeException("Could not resolve 'systemFS' main root directory.");
        }
        if (System.getProperty(MONITOR_DISABLED) == null) {
            this.watchService = this.fs.newWatchService();
            this.configUpdates = new CheckConfigurationUpdates(this.watchService);
            final ConfigServiceWatchServiceExecutor configServiceWatchServiceExecutor = this.getWatchServiceExecutor();
            this.jobs.add(this.executorService.submit((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return ConfigurationServiceImpl.this.configUpdates.getDescription();
                }

                public void run() {
                    ConfigurationServiceImpl.this.configUpdates.execute(configServiceWatchServiceExecutor);
                }
            }));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.configUpdates != null) {
            this.configUpdates.deactivate();
        }
        if (this.watchService != null) {
            this.watchService.close();
        }
        for (Future<?> job : this.jobs) {
            if (job.isCancelled() || job.isDone()) continue;
            job.cancel(true);
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void startBatch() {
        this.ioService.startBatch(this.ioService.get(this.systemRepository.getUri(), new String[0]).getFileSystem());
    }

    public void endBatch() {
        this.ioService.endBatch();
    }

    public List<ConfigGroup> getConfiguration(ConfigType type) {
        if (type.hasNamespace()) {
            throw new RuntimeException("The ConfigType " + type.toString() + " requires a namespace.");
        }
        if (this.configGroupsByTypeWithoutNamespace.containsKey(type)) {
            return this.configGroupsByTypeWithoutNamespace.get(type);
        }
        Path typeDir = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(type.getDir());
        List<ConfigGroup> configGroups = this.getConfiguration(typeDir, type);
        if (configGroups == null) {
            return Collections.emptyList();
        }
        this.configGroupsByTypeWithoutNamespace.put(type, configGroups);
        return configGroups;
    }

    public List<ConfigGroup> getConfiguration(ConfigType type, String namespace) {
        Map<String, List<ConfigGroup>> configGroupsByNamespace;
        if (!type.hasNamespace() && namespace != null && !namespace.isEmpty()) {
            throw new RuntimeException("The ConfigType " + type.toString() + " does not support namespaces.");
        }
        if (this.configGroupsByTypeWithNamespace.containsKey(type) && (configGroupsByNamespace = this.configGroupsByTypeWithNamespace.get(type)).containsKey(namespace)) {
            return configGroupsByNamespace.get(namespace);
        }
        Path typeDir = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(type.getDir());
        Path namespaceDir = typeDir.resolve(namespace);
        List<ConfigGroup> configGroups = this.getConfiguration(namespaceDir, type);
        if (configGroups != null) {
            if (!this.configGroupsByTypeWithNamespace.containsKey(type)) {
                this.configGroupsByTypeWithNamespace.put(type, new ConcurrentHashMap());
            }
        } else {
            return Collections.emptyList();
        }
        Map<String, List<ConfigGroup>> configGroupsByNamespace2 = this.configGroupsByTypeWithNamespace.get(type);
        configGroupsByNamespace2.put(namespace, configGroups);
        return configGroups;
    }

    public Map<String, List<ConfigGroup>> getConfigurationByNamespace(ConfigType type) {
        if (!type.hasNamespace()) {
            throw new RuntimeException("The ConfigType " + type.toString() + " does not support namespaces.");
        }
        Path typeDir = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(type.getDir());
        if (!this.ioService.exists(typeDir)) {
            return Collections.emptyMap();
        }
        DirectoryStream<Path> foundNamespaces = this.getDirectoryStreamForDirectories(typeDir);
        Iterator it = foundNamespaces.iterator();
        while (it.hasNext()) {
            String namespace = Paths.convert((Path)((Path)it.next())).getFileName();
            this.getConfiguration(type, namespace);
        }
        return this.configGroupsByTypeWithNamespace.get(type);
    }

    private List<ConfigGroup> getConfiguration(Path dir, ConfigType type) {
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        if (!this.ioService.exists(dir)) {
            return configGroups;
        }
        DirectoryStream<Path> foundConfigs = this.getDirectoryStreamForFilesWithParticularExtension(dir, type.getExt());
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            return configGroups;
        }
        return null;
    }

    private DirectoryStream<Path> getDirectoryStreamForFilesWithParticularExtension(Path dir, String extension) {
        return this.ioService.newDirectoryStream(dir, entry -> !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(extension));
    }

    private DirectoryStream<Path> getDirectoryStreamForDirectories(Path dir) {
        return this.ioService.newDirectoryStream(dir, entry -> Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]));
    }

    public boolean addConfiguration(ConfigGroup configGroup) {
        Path filePath = this.resolveConfigGroupPath(configGroup);
        String commitMessage = "Created config " + filePath.getFileName();
        return this.saveConfiguration(configGroup, filePath, commitMessage, true);
    }

    public boolean updateConfiguration(ConfigGroup configGroup) {
        Path filePath = this.resolveConfigGroupPath(configGroup);
        String commitMessage = "Updated config " + filePath.getFileName();
        return this.saveConfiguration(configGroup, filePath, commitMessage, false);
    }

    private Path resolveConfigGroupPath(ConfigGroup configGroup) {
        ConfigType type = configGroup.getType();
        String namespace = configGroup.getNamespace();
        if (type.hasNamespace() && (namespace == null || namespace.isEmpty())) {
            throw new RuntimeException("The ConfigType " + type.toString() + " requires a namespace.");
        }
        if (!type.hasNamespace() && namespace != null && !namespace.isEmpty()) {
            throw new RuntimeException("The ConfigType " + type.toString() + " does not support namespaces.");
        }
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path path = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(type.getDir());
        if (type.hasNamespace()) {
            path = path.resolve(namespace);
        }
        return path.resolve(filename + type.getExt());
    }

    private void invalidateCacheAfterUpdatingConfigGroup(ConfigGroup configGroup) {
        ConfigType type = configGroup.getType();
        if (!type.hasNamespace()) {
            this.configGroupsByTypeWithoutNamespace.remove(type);
        } else if (this.configGroupsByTypeWithNamespace.containsKey(type)) {
            this.configGroupsByTypeWithNamespace.get(type).remove(configGroup.getNamespace());
        }
    }

    private boolean saveConfiguration(ConfigGroup configGroup, Path path, String commitMessage, boolean isNew) {
        if (isNew && this.ioService.exists(path)) {
            return true;
        }
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), commitMessage);
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        this.invalidateCacheAfterUpdatingConfigGroup(configGroup);
        return true;
    }

    public boolean removeConfiguration(ConfigGroup configGroup) {
        boolean result;
        Path filePath = this.resolveConfigGroupPath(configGroup);
        if (!this.ioService.exists(filePath)) {
            return true;
        }
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            result = this.ioService.deleteIfExists(filePath, new DeleteOption[0]);
            if (result) {
                this.updateLastModified();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        this.invalidateCacheAfterUpdatingConfigGroup(configGroup);
        return result;
    }

    protected String getIdentityName() {
        try {
            return this.identity.getIdentifier();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    protected long getLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        return this.ioService.getLastModifiedTime(lastModifiedPath).toMillis();
    }

    protected void updateLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        CommentedOption commentedOption = new CommentedOption("system", "system repo updated");
        this.ioService.write(lastModifiedPath, new Date().toString().getBytes(), new OpenOption[]{commentedOption});
        this.localLastModifiedValue.set(this.getLastModified());
    }

    @Override
    public void callback(long value) {
        this.localLastModifiedValue.set(value);
        this.configGroupsByTypeWithoutNamespace.clear();
        this.configGroupsByTypeWithNamespace.clear();
    }

    public boolean cleanUpSystemRepository() {
        try {
            FileSystem fileSystem = this.ioService.get(this.systemRepository.getUri(), new String[0]).getFileSystem();
            if (fileSystem instanceof JGitFileSystem) {
                return ((JGitFileSystem)fileSystem).getGit().resetWithSquash("Repository clean up.");
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to reset git repository.", (Throwable)e);
        }
        return false;
    }

    protected ConfigServiceWatchServiceExecutor getWatchServiceExecutor() {
        if (this.executor == null) {
            ConfigServiceWatchServiceExecutor _executor = null;
            try {
                _executor = (ConfigServiceWatchServiceExecutor)InitialContext.doLookup("java:module/ConfigServiceWatchServiceExecutorImpl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executor == null) {
                _executor = new ConfigServiceWatchServiceExecutorImpl();
                ((ConfigServiceWatchServiceExecutorImpl)_executor).setConfig(this.systemRepository, this.ioService, this.repoChangedEvent, this.spaceChangedEvent, this.changedEvent);
            }
            this.executor = _executor;
        }
        return this.executor;
    }

    private class CheckConfigurationUpdates
    implements AsyncConfigWatchService {
        private final WatchService ws;
        private boolean active = true;

        public CheckConfigurationUpdates(WatchService watchService) {
            this.ws = watchService;
        }

        public void deactivate() {
            this.active = false;
        }

        @Override
        public void execute(ConfigServiceWatchServiceExecutor wsExecutor) {
            while (this.active) {
                try {
                    boolean valid;
                    WatchKey wk;
                    try {
                        wk = this.ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    List events = wk.pollEvents();
                    boolean markerFileModified = false;
                    for (WatchEvent event : events) {
                        WatchContext context = (WatchContext)event.context();
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
                            if (!context.getPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (!event.kind().equals(StandardWatchEventKind.ENTRY_DELETE) || !context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                        markerFileModified = true;
                        break;
                    }
                    if (markerFileModified) {
                        wsExecutor.execute(wk, ConfigurationServiceImpl.this.localLastModifiedValue.get(), ConfigurationServiceImpl.this);
                    }
                    if (valid = wk.reset()) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }

        @Override
        public String getDescription() {
            return "Config File Watch Service";
        }
    }
}

