/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.MultipleInstanceSubProcessPropertyReader;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleInstanceSubProcessPropertyReaderTest {
    private DefinitionResolver definitionResolverReal;
    private MultipleInstanceSubProcessPropertyReader tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolverReal = new DefinitionResolver(definitions, Collections.emptyList());
    }

    @Test
    public void defaultReturnValues() {
        MultipleInstanceSubProcessPropertyReader p = new MultipleInstanceSubProcessPropertyReader(Factories.bpmn2.createSubProcess(), null, (DefinitionResolver)new DummyDefinitionResolver());
        TestCase.assertNull((Object)p.getCollectionInput());
        TestCase.assertNull((Object)p.getCollectionOutput());
        TestCase.assertEquals((String)"", (String)p.getDataInput());
        TestCase.assertEquals((String)"", (String)p.getDataOutput());
        TestCase.assertEquals((String)"", (String)p.getCompletionCondition());
        TestCase.assertEquals((String)"", (String)p.getSlaDueDate());
    }

    @Test
    public void testIsAsync() {
        SubProcess multipleInstanceSubProcess = Factories.bpmn2.createSubProcess();
        multipleInstanceSubProcess.setLoopCharacteristics((LoopCharacteristics)Factories.bpmn2.createMultiInstanceLoopCharacteristics());
        CustomElement.async.of((BaseElement)multipleInstanceSubProcess).set((Object)Boolean.TRUE);
        this.tested = new MultipleInstanceSubProcessPropertyReader(multipleInstanceSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.isAsync());
    }

    @Test
    public void testGetSlaDueDate() {
        String rawSlaDueDate = "12/25/1983";
        SubProcess multipleInstanceSubProcess = Factories.bpmn2.createSubProcess();
        multipleInstanceSubProcess.setLoopCharacteristics((LoopCharacteristics)Factories.bpmn2.createMultiInstanceLoopCharacteristics());
        CustomElement.slaDueDate.of((BaseElement)multipleInstanceSubProcess).set((Object)rawSlaDueDate);
        this.tested = new MultipleInstanceSubProcessPropertyReader(multipleInstanceSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.getSlaDueDate().contains(rawSlaDueDate));
    }

    static class DummyDefinitionResolver
    extends DefinitionResolver {
        DummyDefinitionResolver() {
            super(DummyDefinitionResolver.makeDefinitions(), Collections.emptyList());
        }

        public BPMNShape getShape(String elementId) {
            return null;
        }

        static Definitions makeDefinitions() {
            Definitions d = Factories.bpmn2.createDefinitions();
            BPMNPlane bpmnPlane = Factories.di.createBPMNPlane();
            BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
            bpmnDiagram.setPlane(bpmnPlane);
            d.getDiagrams().add(bpmnDiagram);
            d.getRootElements().add(Factories.bpmn2.createProcess());
            return d;
        }
    }
}

