/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout;

import java.util.Objects;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;

public class OrientedEdgeImpl
implements OrientedEdge {
    private String from;
    private String to;
    private boolean isReversed;

    public OrientedEdgeImpl(String from, String to) {
        this(from, to, false);
    }

    public OrientedEdgeImpl(String from, String to, boolean isReversed) {
        this.from = from;
        this.to = to;
        this.isReversed = isReversed;
    }

    public String getFromVertexId() {
        return this.from;
    }

    public String getToVertexId() {
        return this.to;
    }

    public boolean isLinkedWithVertexId(String vertexId) {
        return this.getFromVertexId().equals(vertexId) || this.getToVertexId().equals(vertexId);
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public void reverse() {
        String oldTo = this.to;
        this.to = this.from;
        this.from = oldTo;
        this.isReversed = !this.isReversed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrientedEdgeImpl) {
            OrientedEdgeImpl that = (OrientedEdgeImpl)obj;
            return Objects.equals(this.getToVertexId(), that.getToVertexId()) && Objects.equals(this.getFromVertexId(), that.getFromVertexId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.isReversed);
    }
}

