/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineStatus;

public class PipelineExecutionListener
implements PipelineEventListener {
    private Event<PipelineStatusChangeEvent> pipelineStatusChangeEvent;
    private Event<StageStatusChangeEvent> stageStatusChangeEvent;

    public PipelineExecutionListener() {
    }

    @Inject
    public PipelineExecutionListener(Event<PipelineStatusChangeEvent> pipelineStatusChangeEvent, Event<StageStatusChangeEvent> stageStatusChangeEvent) {
        this.pipelineStatusChangeEvent = pipelineStatusChangeEvent;
        this.stageStatusChangeEvent = stageStatusChangeEvent;
    }

    public void beforePipelineExecution(BeforePipelineExecutionEvent bpee) {
        this.pipelineStatusChangeEvent.fire((Object)new PipelineStatusChangeEvent(new PipelineExecutionTraceKey(bpee.getExecutionId()), PipelineStatus.RUNNING));
    }

    public void afterPipelineExecution(AfterPipelineExecutionEvent apee) {
        this.pipelineStatusChangeEvent.fire((Object)new PipelineStatusChangeEvent(new PipelineExecutionTraceKey(apee.getExecutionId()), PipelineStatus.FINISHED));
    }

    public void beforeStageExecution(BeforeStageExecutionEvent bsee) {
        this.stageStatusChangeEvent.fire((Object)new StageStatusChangeEvent(new PipelineExecutionTraceKey(bsee.getExecutionId()), bsee.getStage().getName(), PipelineStatus.RUNNING));
    }

    public void onStageError(OnErrorStageExecutionEvent oesee) {
        this.stageStatusChangeEvent.fire((Object)new StageStatusChangeEvent(new PipelineExecutionTraceKey(oesee.getExecutionId()), oesee.getStage().getName(), PipelineStatus.ERROR));
    }

    public void afterStageExecution(AfterStageExecutionEvent asee) {
        this.stageStatusChangeEvent.fire((Object)new StageStatusChangeEvent(new PipelineExecutionTraceKey(asee.getExecutionId()), asee.getStage().getName(), PipelineStatus.FINISHED));
    }

    public void onPipelineError(OnErrorPipelineExecutionEvent oepee) {
        this.pipelineStatusChangeEvent.fire((Object)new PipelineStatusChangeEvent(new PipelineExecutionTraceKey(oepee.getExecutionId()), PipelineStatus.ERROR));
    }
}

