/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;

@Service
@ApplicationScoped
public class SourceServiceImpl
implements SourceService {
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private ModuleService<? extends Module> moduleService;
    private AuthorizationManager authorizationManager;
    private User identity;

    public SourceServiceImpl() {
    }

    @Inject
    public SourceServiceImpl(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, ModuleService<? extends Module> moduleService, AuthorizationManager authorizationManager, User identity) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.moduleService = moduleService;
        this.authorizationManager = authorizationManager;
        this.identity = identity;
    }

    public Collection<String> getOrganizationUnits() {
        return this.organizationalUnitService.getOrganizationalUnits().stream().map(OrganizationalUnit::getName).collect(Collectors.toList());
    }

    public Collection<String> getRepositories(String organizationalUnit) {
        PortablePreconditions.checkNotNull((String)"organizationalUnit", (Object)organizationalUnit);
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit);
        if (ou == null) {
            return new ArrayList<String>();
        }
        return this.organizationalUnitService.getOrganizationalUnit(organizationalUnit).getRepositories().stream().filter(repository -> this.authorizationManager.authorize((Resource)repository, this.identity)).map(Repository::getAlias).collect(Collectors.toList());
    }

    public Collection<String> getBranches(Space space, String repositoryName) {
        PortablePreconditions.checkNotNull((String)"repositoryName", (Object)repositoryName);
        Repository repository = this.repositoryService.getRepositoryFromSpace(space, repositoryName);
        return repository != null ? this.toBranchNames(repository.getBranches()) : new ArrayList();
    }

    public Collection<Module> getModules(Space space, String repositoryAlias, String branchName) {
        PortablePreconditions.checkNotNull((String)"repositoryAlias", (Object)repositoryAlias);
        PortablePreconditions.checkNotNull((String)"branchName", (Object)branchName);
        Repository repository = this.repositoryService.getRepositoryFromSpace(space, repositoryAlias);
        if (repository == null) {
            return new ArrayList<Module>();
        }
        Optional branch = repository.getBranch(branchName);
        if (branch.isPresent()) {
            return this.moduleService.getAllModules((Branch)branch.get());
        }
        return new ArrayList<Module>();
    }

    private Collection<String> toBranchNames(Collection<Branch> branches) {
        ArrayList<String> result = new ArrayList<String>();
        for (Branch branch : branches) {
            result.add(branch.getName());
        }
        return result;
    }
}

