/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.DataTypeCacheServer;
import org.kie.workbench.common.stunner.bpmn.project.service.DataTypesService;
import org.uberfire.backend.vfs.Path;

@Service
public class BPMNFindDataTypesProjectService
implements DataTypesService {
    private DataModelService dataModelService;
    private DataTypeCacheServer dataTypeCacheServer;

    protected BPMNFindDataTypesProjectService() {
        this(null, null);
    }

    @Inject
    public BPMNFindDataTypesProjectService(DataModelService dataModelService, DataTypeCacheServer dataTypeCacheServer) {
        this.dataModelService = dataModelService;
        this.dataTypeCacheServer = dataTypeCacheServer;
    }

    public List<String> getDataTypeNames(Path path, List<String> addedDataTypes) {
        if (null == path) {
            return Collections.emptyList();
        }
        ArrayList<String> dataTypeNames = new ArrayList<String>();
        dataTypeNames.addAll(this.dataTypeCacheServer.getCachedDataTypes());
        try {
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            String[] fullyQualifiedClassNames = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)oracle);
            for (int i = 0; i < fullyQualifiedClassNames.length; ++i) {
                fullyQualifiedClassNames[i] = "Asset-" + fullyQualifiedClassNames[i];
            }
            dataTypeNames.addAll(Arrays.asList(fullyQualifiedClassNames));
            if (addedDataTypes != null) {
                dataTypeNames.addAll(addedDataTypes);
            }
            List collect = dataTypeNames.stream().distinct().collect(Collectors.toList());
            Collections.sort(collect);
            dataTypeNames.clear();
            dataTypeNames.addAll(collect);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return dataTypeNames;
    }
}

