/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.rest.backend.JobRequestHelper;
import org.guvnor.rest.backend.JobResultManager;
import org.guvnor.rest.backend.cmd.AbstractJobCommand;
import org.guvnor.rest.backend.cmd.AddBranchCmd;
import org.guvnor.rest.backend.cmd.AddProjectToSpaceCmd;
import org.guvnor.rest.backend.cmd.CloneRepositoryCmd;
import org.guvnor.rest.backend.cmd.CompileProjectCmd;
import org.guvnor.rest.backend.cmd.CreateProjectCmd;
import org.guvnor.rest.backend.cmd.CreateSpaceCmd;
import org.guvnor.rest.backend.cmd.DeleteProjectCmd;
import org.guvnor.rest.backend.cmd.DeployProjectCmd;
import org.guvnor.rest.backend.cmd.InstallProjectCmd;
import org.guvnor.rest.backend.cmd.RemoveBranchCmd;
import org.guvnor.rest.backend.cmd.RemoveSpaceCmd;
import org.guvnor.rest.backend.cmd.TestProjectCmd;
import org.guvnor.rest.backend.cmd.UpdateSpaceCmd;
import org.guvnor.rest.client.AddBranchJobRequest;
import org.guvnor.rest.client.AddProjectToSpaceRequest;
import org.guvnor.rest.client.CloneProjectJobRequest;
import org.guvnor.rest.client.CompileProjectRequest;
import org.guvnor.rest.client.CreateProjectJobRequest;
import org.guvnor.rest.client.DeleteProjectRequest;
import org.guvnor.rest.client.DeployProjectRequest;
import org.guvnor.rest.client.InstallProjectRequest;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.RemoveBranchJobRequest;
import org.guvnor.rest.client.RemoveSpaceRequest;
import org.guvnor.rest.client.SpaceRequest;
import org.guvnor.rest.client.TestProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.concurrent.Unmanaged;

@ApplicationScoped
public class JobRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestScheduler.class);
    private static final String ACCEPT_LANGUAGE = "acceptLanguage";
    private ExecutorService executorService;
    private JobResultManager jobResultManager;
    private JobRequestHelper jobRequestHelper;

    public JobRequestScheduler() {
    }

    @Inject
    public JobRequestScheduler(@Unmanaged ExecutorService executorService, JobResultManager jobResultManager, JobRequestHelper jobRequestHelper) {
        this.executorService = executorService;
        this.jobResultManager = jobResultManager;
        this.jobRequestHelper = jobRequestHelper;
    }

    public void cloneProjectRequest(CloneProjectJobRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Space", jobRequest.getCloneProjectRequest().getName());
        params.put("Operation", "cloneProject");
        this.scheduleJob((JobRequest)jobRequest, new CloneRepositoryCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void createProjectRequest(CreateProjectJobRequest jobRequest, Map<String, Object> headers) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Space", jobRequest.getSpaceName());
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "createProject");
        params.put(ACCEPT_LANGUAGE, headers.get(ACCEPT_LANGUAGE));
        this.scheduleJob((JobRequest)jobRequest, new CreateProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void deleteProjectRequest(DeleteProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "deleteProject");
        this.scheduleJob((JobRequest)jobRequest, new DeleteProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void compileProjectRequest(CompileProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Branch", jobRequest.getBranchName());
        params.put("Operation", "compileProject");
        this.scheduleJob((JobRequest)jobRequest, new CompileProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void installProjectRequest(InstallProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Branch", jobRequest.getBranchName());
        params.put("Operation", "installProject");
        this.scheduleJob((JobRequest)jobRequest, new InstallProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void testProjectRequest(TestProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Branch", jobRequest.getBranchName());
        params.put("Operation", "testProject");
        this.scheduleJob((JobRequest)jobRequest, new TestProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void deployProjectRequest(DeployProjectRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Branch", jobRequest.getBranchName());
        params.put("Operation", "deployProject");
        this.scheduleJob((JobRequest)jobRequest, new DeployProjectCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void createSpaceRequest(SpaceRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "createOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new CreateSpaceCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void updateSpaceRequest(SpaceRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "updateOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new UpdateSpaceCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void addProjectToSpace(AddProjectToSpaceRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Project", jobRequest.getProjectName());
        params.put("Operation", "addRepositoryToOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new AddProjectToSpaceCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void addBranchRequest(AddBranchJobRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Space", jobRequest.getSpaceName());
        params.put("Project", jobRequest.getProjectName());
        params.put("NewBranchName", jobRequest.getNewBranchName());
        params.put("BaseBranchName", jobRequest.getBaseBranchName());
        params.put("Operation", "addBranch");
        this.scheduleJob((JobRequest)jobRequest, new AddBranchCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void removeBranchRequest(RemoveBranchJobRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Space", jobRequest.getSpaceName());
        params.put("Project", jobRequest.getProjectName());
        params.put("BranchName", jobRequest.getBranchName());
        params.put("Operation", "addBranch");
        this.scheduleJob((JobRequest)jobRequest, new RemoveBranchCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    public void removeSpaceRequest(RemoveSpaceRequest jobRequest) {
        Map<String, Object> params = this.getContext((JobRequest)jobRequest);
        params.put("Operation", "removeOrgUnit");
        this.scheduleJob((JobRequest)jobRequest, new RemoveSpaceCmd(this.jobRequestHelper, this.jobResultManager, params));
    }

    protected Map<String, Object> getContext(JobRequest jobRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("JobRequest", jobRequest);
        params.put("BusinessKey", jobRequest.getJobId());
        params.put("Retries", 0);
        return params;
    }

    private void scheduleJob(JobRequest jobRequest, AbstractJobCommand command) {
        jobRequest.setStatus(JobStatus.APPROVED);
        logger.debug("Scheduling job request with id: {} and command class: {}", (Object)jobRequest.getJobId(), (Object)command.getClass().getName());
        this.executorService.execute((Runnable)((Object)command));
    }
}

