/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateCompensationEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateCompensationEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryCompensationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_4AAF367B-3F0C-41B9-A57C-3979D614511A";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_5C70D78D-2204-4E90-8F06-7E03C45F843D";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_47B678A0-FF16-4370-BA09-C0C9CE562D36";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_ECDEBCD9-25E0-40C1-B970-047D3011B4D9";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_C04BCC72-55B8-4DB4-81E6-01971E346594";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_597D1EF7-0754-4843-A22E-6941138D852A";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_A6663578-4B8E-4EB7-AA72-936EBA2A6713";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_920B9AF9-8959-4AEB-97FD-5B0C8EFF1F8B";
    private static final String SLA_DUE_DATE = "P1y8m17dT23h19m38s";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 27;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Compensation01\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent filledTopEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Compensation01\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledTopEvent.getExecutionSet(), false, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent emptyTopEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptyTopEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Compensation03\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent filledSubprocessEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation03\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), false, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent emptySubprocessEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Compensation02\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent filledSubprocessEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation02\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), false, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent emptyEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptyEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent emptySubprocessEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Compensation04\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 27);
        IntermediateCompensationEvent filledSubprocessEvent = (IntermediateCompensationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation04\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), false, SLA_DUE_DATE);
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateCompensationEvent> getCatchingIntermediateEventType() {
        return IntermediateCompensationEvent.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertCompensationEventExecutionSet(BaseCancellingEventExecutionSet executionSet, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        this.assertEventCancelActivity(executionSet, isCancelling);
        this.assertEventSlaDueDate(executionSet, slaDueDate);
    }
}

