/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.InternalMarshaller;
import org.drools.core.marshalling.impl.KieSessionInitializer;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.serialization.protobuf.ProtobufInputMarshaller;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.ProtobufOutputMarshaller;
import org.drools.serialization.protobuf.ReadSessionResult;
import org.drools.serialization.protobuf.TimersInputMarshaller;
import org.drools.serialization.protobuf.timers.BehaviorJobContextTimerInputMarshaller;
import org.drools.serialization.protobuf.timers.ExpireJobContextTimerInputMarshaller;
import org.drools.serialization.protobuf.timers.TimerNodeTimerInputMarshaller;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProtobufMarshaller
implements InternalMarshaller {
    protected KieSessionInitializer initializer;
    public static final Map<Integer, TimersInputMarshaller> TIMER_READERS = new HashMap<Integer, TimersInputMarshaller>();
    protected KieBase kbase;
    protected RuleBaseConfiguration ruleBaseConfig;
    protected MarshallingConfiguration marshallingConfig;
    protected ObjectMarshallingStrategyStore strategyStore;

    public KieSessionInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(KieSessionInitializer initializer) {
        this.initializer = initializer;
    }

    public ProtobufMarshaller(KieBase kbase, MarshallingConfiguration marshallingConfig) {
        this.kbase = kbase;
        this.ruleBaseConfig = RuleBaseConfiguration.getDefaultInstance();
        this.marshallingConfig = marshallingConfig;
        this.strategyStore = this.marshallingConfig.getObjectMarshallingStrategyStore();
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        return this.unmarshallWithMessage(stream, config, environment).getSession();
    }

    public void unmarshall(InputStream stream, KieSession ksession) throws IOException, ClassNotFoundException {
        ProtobufMarshallerReaderContext context = this.getMarshallerReaderContext(stream, ksession.getEnvironment());
        ProtobufInputMarshaller.readSession((StatefulKnowledgeSessionImpl)ksession, context);
        context.close();
    }

    public void marshall(OutputStream stream, KieSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, KieSession ksession, long clockTime) throws IOException {
        ((InternalWorkingMemory)ksession).flushPropagations();
        ProtobufMarshallerWriteContext context = new ProtobufMarshallerWriteContext(stream, (InternalKnowledgeBase)this.kbase, (InternalWorkingMemory)ksession, RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)this.kbase)), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.setClockTime(clockTime);
        ProtobufOutputMarshaller.writeSession(context);
        context.close();
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }

    public ReadSessionResult unmarshallWithMessage(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KieServices.get().newEnvironment();
        }
        ProtobufMarshallerReaderContext context = this.getMarshallerReaderContext(stream, environment);
        int id = ((KnowledgeBaseImpl)this.kbase).nextWorkingMemoryCounter();
        ReadSessionResult readSessionResult = ProtobufInputMarshaller.readSession(context, id, environment, (SessionConfiguration)config, this.initializer);
        context.close();
        if (((SessionConfiguration)config).isKeepReference()) {
            ((KnowledgeBaseImpl)this.kbase).addStatefulSession(readSessionResult.getSession());
        }
        return readSessionResult;
    }

    private ProtobufMarshallerReaderContext getMarshallerReaderContext(InputStream inputStream, Environment environment) throws IOException {
        return new ProtobufMarshallerReaderContext(inputStream, (InternalKnowledgeBase)((KnowledgeBaseImpl)this.kbase), RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((KnowledgeBaseImpl)this.kbase)), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
    }

    static {
        TIMER_READERS.put(3, new BehaviorJobContextTimerInputMarshaller());
        TIMER_READERS.put(1, new ExpireJobContextTimerInputMarshaller());
        TIMER_READERS.put(5, new TimerNodeTimerInputMarshaller());
    }
}

