/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.jbpm.process.builder.EventBasedNodeBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;

public class WorkItemNodeBuilder
extends EventBasedNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        List assignments;
        DataTransformer transformer;
        Transformation transformation;
        super.build(process, processDescr, context, node);
        WorkflowProcess wfProcess = (WorkflowProcess)process;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("imports", wfProcess.getImports());
        parameters.put("classloader", context.getConfiguration().getClassLoader());
        for (DataAssociation dataAssociation : ((WorkItemNode)node).getInAssociations()) {
            transformation = dataAssociation.getTransformation();
            if (transformation != null) {
                transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
            }
            if ((assignments = dataAssociation.getAssignments()) == null) continue;
            for (Assignment assignment : assignments) {
                ProcessDialect dialect = ProcessDialectRegistry.getDialect(assignment.getDialect());
                AssignmentProducer producer = (pc, ni, target) -> {
                    WorkItemNodeInstance wini = (WorkItemNodeInstance)ni;
                    wini.getWorkItem().setParameter(dataAssociation.getTarget(), target);
                };
                BiFunction<ProcessContext, NodeInstance, Object> source = (pc, ni) -> pc.getVariable((String)dataAssociation.getSources().get(0));
                BiFunction<ProcessContext, NodeInstance, Object> target2 = (pc, ni) -> ((WorkItemNodeInstance)ni).getWorkItem().getParameter(dataAssociation.getTarget());
                dialect.getAssignmentBuilder().build(context, assignment, (String)dataAssociation.getSources().get(0), dataAssociation.getTarget(), source, target2, producer);
            }
        }
        for (DataAssociation dataAssociation : ((WorkItemNode)node).getOutAssociations()) {
            transformation = dataAssociation.getTransformation();
            if (transformation != null) {
                transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
            }
            if ((assignments = dataAssociation.getAssignments()) == null) continue;
            for (Assignment assignment : assignments) {
                AssignmentProducer producer = (pc, ni, target) -> pc.setVariable(dataAssociation.getTarget(), target);
                BiFunction<ProcessContext, NodeInstance, Object> source = (pc, ni) -> ((WorkItemNodeInstance)ni).getWorkItem().getResult((String)dataAssociation.getSources().get(0));
                BiFunction<ProcessContext, NodeInstance, Object> target3 = (pc, ni) -> pc.getVariable(dataAssociation.getTarget());
                ProcessDialect dialect = ProcessDialectRegistry.getDialect(assignment.getDialect());
                dialect.getAssignmentBuilder().build(context, assignment, (String)dataAssociation.getSources().get(0), dataAssociation.getTarget(), source, target3, producer);
            }
        }
    }
}

