/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.FormGenerationResult;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.Runtime;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.model.FormDefinition;

@Dependent
public class DynamicBPMNFormGeneratorImpl
implements DynamicBPMNFormGenerator {
    private BPMNFormGeneratorService<ClassLoader> formGeneratorService;

    @Inject
    public DynamicBPMNFormGeneratorImpl(@Runtime BPMNFormGeneratorService<ClassLoader> formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    public Collection<FormDefinition> generateProcessForms(BusinessProcessFormModel model, ClassLoader classLoader) {
        return this.createFormDefinition((JBPMFormModel)model, classLoader);
    }

    public Collection<FormDefinition> generateTaskForms(TaskFormModel model, ClassLoader classLoader) {
        return this.createFormDefinition((JBPMFormModel)model, classLoader);
    }

    protected Collection<FormDefinition> createFormDefinition(JBPMFormModel model, ClassLoader classLoader) {
        FormGenerationResult generationResult = this.formGeneratorService.generateForms(model, classLoader);
        ArrayList<FormDefinition> result = new ArrayList<FormDefinition>();
        result.add(generationResult.getRootForm());
        result.addAll(generationResult.getNestedForms());
        return result;
    }
}

