/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.runtime;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReader;
import org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.util.DMOModelResolver;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ModuleDataModelOracleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDMOModelReader
implements ModelReader {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeDMOModelReader.class);
    private ClassLoader classLoader;
    private MVELEvaluator evaluator;

    public RuntimeDMOModelReader(ClassLoader classLoader, MVELEvaluator evaluator) {
        this.classLoader = classLoader;
        this.evaluator = evaluator;
    }

    public DataObjectFormModel readFormModel(String typeName) {
        return DMOModelResolver.resolveModelForType(this.getModuleOracle(typeName), typeName);
    }

    public Collection<DataObjectFormModel> readModuleFormModels() {
        throw new RuntimeException("Unsupported operation: RuntimeDMOModelReader doesn't support listing models");
    }

    public Collection<DataObjectFormModel> readAllFormModels() {
        throw new RuntimeException("Unsupported operation: RuntimeDMOModelReader doesn't support listing all models");
    }

    private ModuleDataModelOracle getModuleOracle(String typeName) {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(typeName);
            if (clazz == null) {
                this.getClass();
                clazz = Class.forName(typeName);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to extract model for class '{}'.", (Object)typeName);
            throw new IllegalStateException("Unable to extract model for class '" + typeName + "'");
        }
        if (clazz == null) {
            logger.error("Unable to extract model for class '{}'.", (Object)typeName);
            throw new IllegalStateException("Unable to extract model for class '" + typeName + "'");
        }
        try {
            ModuleDataModelOracleBuilder builder = ModuleDataModelOracleBuilder.newModuleOracleBuilder((MVELEvaluator)this.evaluator);
            ClassFactBuilder modelFactBuilder = new ClassFactBuilder(builder, clazz, false, type -> TypeSource.JAVA_PROJECT);
            ModuleDataModelOracle oracle = modelFactBuilder.getDataModelBuilder().build();
            HashMap<String, Object> builders = new HashMap<String, Object>();
            for (FactBuilder factBuilder : modelFactBuilder.getInternalBuilders().values()) {
                if (!(factBuilder instanceof ClassFactBuilder)) continue;
                builders.put(((ClassFactBuilder)factBuilder).getType(), factBuilder);
                factBuilder.build((ModuleDataModelOracleImpl)oracle);
            }
            builders.put(modelFactBuilder.getType(), modelFactBuilder);
            modelFactBuilder.build((ModuleDataModelOracleImpl)oracle);
            return oracle;
        }
        catch (IOException ex) {
            logger.warn("Couldn't inspect model {} due to: {}", (Object)typeName, (Object)ex);
            return null;
        }
    }
}

