/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.AbstractElement;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Portable
public class GraphImpl<C>
extends AbstractElement<C>
implements Graph<C, Node> {
    private final GraphNodeStore<Node> nodeStore;

    public static <C> GraphImpl<C> build(String uuid) {
        return new GraphImpl<C>(uuid, new GraphNodeStoreImpl());
    }

    public GraphImpl(@MapsTo(value="uuid") String uuid, @MapsTo(value="nodeStore") GraphNodeStore<Node> nodeStore) {
        super(uuid);
        this.nodeStore = (GraphNodeStore)PortablePreconditions.checkNotNull((String)"nodeStore", nodeStore);
    }

    public Node addNode(Node node) {
        return (Node)this.nodeStore.add((Element)node);
    }

    public Node removeNode(String uuid) {
        return (Node)this.nodeStore.remove(uuid);
    }

    public Node getNode(String uuid) {
        return (Node)this.nodeStore.get(uuid);
    }

    public Iterable<Node> nodes() {
        return this.nodeStore;
    }

    public void clear() {
        this.nodeStore.clear();
    }

    public Node<C, Edge> asNode() {
        return null;
    }

    public Edge<C, Node> asEdge() {
        return null;
    }

    @Override
    public int hashCode() {
        return GraphUtils.computeGraphHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GraphImpl) {
            GraphImpl g = (GraphImpl)o;
            return this.hashCode() == g.hashCode();
        }
        return false;
    }
}

