/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.ConnectorCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.handler.impl.EdgeCardinalityEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class ConnectorCardinalityEvaluationHandler
implements RuleEvaluationHandler<EdgeOccurrences, ConnectorCardinalityContext> {
    private final GraphEvaluationHandlerUtils evalUtils;
    private final EdgeCardinalityEvaluationHandler edgeCardinalityEvaluationHandler;

    @Inject
    public ConnectorCardinalityEvaluationHandler(DefinitionManager definitionManager, EdgeCardinalityEvaluationHandler edgeCardinalityEvaluationHandler) {
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
        this.edgeCardinalityEvaluationHandler = edgeCardinalityEvaluationHandler;
    }

    ConnectorCardinalityEvaluationHandler(GraphEvaluationHandlerUtils evalUtils, EdgeCardinalityEvaluationHandler edgeCardinalityEvaluationHandler) {
        this.evalUtils = evalUtils;
        this.edgeCardinalityEvaluationHandler = edgeCardinalityEvaluationHandler;
    }

    public Class<EdgeOccurrences> getRuleType() {
        return EdgeOccurrences.class;
    }

    public Class<ConnectorCardinalityContext> getContextType() {
        return ConnectorCardinalityContext.class;
    }

    public boolean accepts(EdgeOccurrences rule, ConnectorCardinalityContext context) {
        Edge edge = context.getEdge();
        Element candidate = context.getCandidate();
        String edgeId = this.evalUtils.getElementDefinitionId((Element<?>)edge);
        Set<String> candidateRoles = this.evalUtils.getLabels(candidate);
        return this.edgeCardinalityEvaluationHandler.accepts(rule, RuleEvaluationContextBuilder.DomainContexts.edgeCardinality(candidateRoles, edgeId, -1, context.getDirection(), context.getOperation()));
    }

    public RuleViolations evaluate(EdgeOccurrences rule, ConnectorCardinalityContext context) {
        GraphEvaluationState.ConnectorCardinalityState cardinalityState = context.getState().getConnectorCardinalityState();
        DefaultRuleViolations result = new DefaultRuleViolations();
        Node candidate = (Node)context.getCandidate();
        Edge edge = context.getEdge();
        Optional operation = context.getOperation();
        EdgeCardinalityContext.Direction direction = context.getDirection();
        Collection edges = this.isIncoming(direction) ? cardinalityState.getIncoming(candidate) : cardinalityState.getOutgoing(candidate);
        String edgeId = this.evalUtils.getElementDefinitionId((Element<?>)edge);
        int count = this.evalUtils.countEdges(edgeId, edges);
        result.addViolations(this.edgeCardinalityEvaluationHandler.evaluate(rule, RuleEvaluationContextBuilder.DomainContexts.edgeCardinality(candidate.getLabels(), edgeId, count, rule.getDirection(), operation)));
        return GraphEvaluationHandlerUtils.addViolationsSourceUUID(edge.getUUID(), result);
    }

    private boolean isIncoming(EdgeCardinalityContext.Direction direction) {
        return EdgeCardinalityContext.Direction.INCOMING.equals((Object)direction);
    }
}

