/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.utils;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.kie.workbench.common.screens.server.management.backend.storage.ServerTemplateOCPStorage;
import org.kie.workbench.common.screens.server.management.backend.storage.ServerTemplateVFSStorage;
import org.kie.workbench.common.screens.server.management.backend.utils.EmbeddedController;
import org.kie.workbench.common.screens.server.management.backend.utils.StandaloneController;
import org.kie.workbench.common.screens.server.management.utils.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerExtension.class);

    public <T> void processStandaloneController(@WithAnnotations(value={StandaloneController.class}) @Observes ProcessAnnotatedType<T> event) {
        LOGGER.info("Processing standalone controller class: {}", (Object)event.getAnnotatedType().getJavaClass());
        StandaloneController a = event.getAnnotatedType().getJavaClass().getAnnotation(StandaloneController.class);
        if (a != null && ControllerUtils.useEmbeddedController()) {
            this.removeControllerClassFromCDIContext(event);
        }
    }

    public <T> void processEmbeddedController(@WithAnnotations(value={EmbeddedController.class}) @Observes ProcessAnnotatedType<T> event) {
        LOGGER.info("Processing embedded controller class: {}", (Object)event.getAnnotatedType().getJavaClass());
        EmbeddedController a = event.getAnnotatedType().getJavaClass().getAnnotation(EmbeddedController.class);
        if (a != null) {
            if (ControllerUtils.useEmbeddedController()) {
                if (ControllerUtils.isOpenShiftSupported()) {
                    if (ServerTemplateVFSStorage.class.isAssignableFrom(event.getAnnotatedType().getJavaClass())) {
                        this.removeControllerClassFromCDIContext(event);
                    }
                } else if (ServerTemplateOCPStorage.class.isAssignableFrom(event.getAnnotatedType().getJavaClass())) {
                    this.removeControllerClassFromCDIContext(event);
                }
            } else {
                this.removeControllerClassFromCDIContext(event);
            }
        }
    }

    private <T> void removeControllerClassFromCDIContext(ProcessAnnotatedType<T> event) {
        LOGGER.info("Removing controller class {} from CDI context", (Object)event.getAnnotatedType().getJavaClass());
        event.veto();
    }
}

