/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.MethodMockTransformer;

public class MethodSizeMockTransformer
extends MethodMockTransformer {
    private static final int MAX_METHOD_CODE_LENGTH_LIMIT = 65536;

    public MethodSizeMockTransformer(TransformStrategy strategy) {
        super(strategy);
    }

    @Override
    public CtClass transform(CtClass clazz) throws CannotCompileException, NotFoundException {
        for (CtMethod method : clazz.getDeclaredMethods()) {
            if (!this.isMethodSizeExceeded(method)) continue;
            String code = "{throw new IllegalAccessException(\"Method was too large and after instrumentation exceeded JVM limit. PowerMock modified the method to allow JVM to load the class. You can use PowerMock API to suppress or mock this method behaviour.\");}";
            method.setBody(code);
            this.modifyMethod(method);
        }
        return clazz;
    }

    private boolean isMethodSizeExceeded(CtMethod method) {
        CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
        return codeAttribute != null && codeAttribute.getCodeLength() >= 65536;
    }
}

