/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class CatchingIntermediateConditionalEventTest
extends CatchingIntermediateEventTest<IntermediateConditionalEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/catchingIntermediateConditionalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_044118FA-752D-4EC6-8579-395A7A954DC9";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_20EA1508-A139-4894-961F-812BEB9C48D4";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_CA3E010C-70B6-4C04-A9F3-1C8B5468127F";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_61515EDE-F4C3-49E2-843B-48A55EFE3BAE";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_EC53B093-411B-40BA-933E-796194B6093B";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_04DADAAA-95FE-4F72-838F-17379D5A1B19";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_1CE0925E-8DF3-4B38-A419-8F74ACDB869A";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_4DA840DF-0635-4BFF-B06A-6BAB3E5545B9";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;
    private static final String CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE = null;
    private static final String CONDITION_EXPRESSION_LANGUAGE = "drools";
    private static final String CONDITION_EXPRESSION_TYPE = "stunner.bpmn.ScriptType";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Event 01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent filledTopEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Event 01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledTopEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent emptyTopEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptyTopEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Event 03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Event 03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent emptySubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Event 02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Event 02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent emptyEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptyEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent emptySubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertConditionalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), CONDITION_EXPRESSION_SCRIPT_DEFAULT_VALUE, CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Event 04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CONDITION_EXPRESSION_SCRIPT = "com.myspace.testproject.Person(name == \"John\")";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateConditionalEvent filledSubprocessEvent = (IntermediateConditionalEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Event 04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertConditionalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "com.myspace.testproject.Person(name == \"John\")", CONDITION_EXPRESSION_LANGUAGE, CONDITION_EXPRESSION_TYPE, true, SLA_DUE_DATE);
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateConditionalEvent> getCatchingIntermediateEventType() {
        return IntermediateConditionalEvent.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertConditionalEventExecutionSet(CancellingConditionalEventExecutionSet executionSet, String conditionExpressionScript, String conditionExpressionLanguage, String conditionExpressionType, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getConditionExpression()).isNotNull();
        Assertions.assertThat((Object)executionSet.getConditionExpression().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getConditionExpression().getType()).isNotNull();
        Assertions.assertThat((String)executionSet.getConditionExpression().getValue().getLanguage()).isEqualTo(conditionExpressionLanguage);
        Assertions.assertThat((String)executionSet.getConditionExpression().getValue().getScript()).isEqualTo(conditionExpressionScript);
        Assertions.assertThat((String)executionSet.getConditionExpression().getType().getName()).isEqualTo(conditionExpressionType);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

