/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.ResultComposer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.core.util.StringUtils;

final class ProcessConverterDelegate {
    protected final TypedFactoryManager factoryManager;
    protected final PropertyReaderFactory propertyReaderFactory;
    protected final DefinitionResolver definitionResolver;
    private final BaseConverterFactory converterFactory;

    ProcessConverterDelegate(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory factory) {
        this.factoryManager = typedFactoryManager;
        this.definitionResolver = definitionResolver;
        this.propertyReaderFactory = propertyReaderFactory;
        this.converterFactory = factory;
    }

    Result<Map<String, BpmnNode>> convertChildNodes(BpmnNode firstNode, List<FlowElement> flowElements, List<LaneSet> laneSets) {
        for (FlowElement element : flowElements) {
            element.setId(StringUtils.revertIllegalCharsAttribute((String)element.getId()));
            element.setName(StringUtils.revertIllegalCharsAttribute((String)element.getName()));
        }
        Result<Map<String, BpmnNode>> flowElementsResult = this.convertFlowElements(flowElements);
        Map<String, BpmnNode> freeFloatingNodes = flowElementsResult.value();
        freeFloatingNodes.values().forEach(n -> n.setParent(firstNode));
        Result[] laneSetsResult = this.convertLaneSets(laneSets, freeFloatingNodes, firstNode);
        Map<String, BpmnNode> lanesMap = Stream.of(laneSetsResult).filter(Objects::nonNull).map(v -> (BpmnNode)v.value()).collect(Collectors.toMap(n -> n.value().getUUID(), n -> n));
        freeFloatingNodes.putAll(lanesMap);
        return ResultComposer.compose(freeFloatingNodes, flowElementsResult, ResultComposer.compose(laneSets, laneSetsResult));
    }

    Result<Boolean> convertEdges(BpmnNode processRoot, List<BaseElement> flowElements, Map<String, BpmnNode> nodes) {
        List results = flowElements.stream().map(e -> this.converterFactory.edgeConverter().convertEdge((BaseElement)e, nodes)).filter(Result::isSuccess).collect(Collectors.toList());
        boolean value = results.size() > 0 ? results.stream().map(Result::value).filter(Objects::nonNull).map(processRoot::addEdge).allMatch(Boolean.TRUE::equals) : false;
        return ResultComposer.compose(Boolean.valueOf(value), results);
    }

    private Result<Map<String, BpmnNode>> convertFlowElements(List<FlowElement> flowElements) {
        List results = flowElements.stream().map(this.converterFactory.flowElementConverter()::convertNode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, BpmnNode> resultMap = results.stream().map(Result::value).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.value().getUUID(), n -> n));
        return ResultComposer.compose(resultMap, results);
    }

    private Result<BpmnNode>[] convertLaneSets(List<LaneSet> laneSets, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        Result[] results = (Result[])laneSets.stream().map(laneSet -> this.convertLaneSet((LaneSet)laneSet, (List<Lane>)new ArrayList<Lane>(), freeFloatingNodes, firstDiagramNode)).flatMap(Stream::of).toArray(Result[]::new);
        return results;
    }

    private Result<BpmnNode>[] convertLane(Lane lane, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        if (lane.getChildLaneSet() != null) {
            parents.add(lane);
            Result<BpmnNode>[] laneSetResult = this.convertLaneSet(lane.getChildLaneSet(), parents, freeFloatingNodes, firstDiagramNode);
            parents.removeIf(parent -> Objects.equals(parent.getId(), lane.getId()));
            return laneSetResult;
        }
        Result<BpmnNode> laneResult = !parents.isEmpty() && lane != parents.get(0) ? this.converterFactory.laneConverter().convert(lane, parents.get(0)) : this.converterFactory.laneConverter().convert(lane);
        Optional<BpmnNode> value = Optional.ofNullable(laneResult.value());
        value.ifPresent(laneNode -> laneNode.setParent(firstDiagramNode));
        value.ifPresent(laneNode -> lane.getFlowNodeRefs().forEach(node -> ((BpmnNode)freeFloatingNodes.get(node.getId())).setParent((BpmnNode)laneNode)));
        return new Result[]{laneResult};
    }

    private Result<BpmnNode>[] convertLaneSet(LaneSet laneSet, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        Result[] results = (Result[])laneSet.getLanes().stream().map(lane -> this.convertLane((Lane)lane, parents, freeFloatingNodes, firstDiagramNode)).flatMap(Stream::of).toArray(Result[]::new);
        return results;
    }

    Result<BpmnNode> postConvert(BpmnNode processRoot) {
        return this.converterFactory.newProcessPostConverter().postConvert(processRoot, this.definitionResolver);
    }
}

