/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.util;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;

public class ControlPointValidations {
    public static Predicate<Integer> isControlPointIndexInvalid = index -> index < 0;
    public static Predicate<ControlPoint> isControlPointInvalid = cp -> null == cp.getLocation();
    public static BiPredicate<ControlPoint[], Integer> isAddingControlPointIndexForbidden = (cps, index) -> null != cps && index > ((ControlPoint[])cps).length || null == cps && index != 0;
    public static BiPredicate<ControlPoint[], Integer> isDeletingControlPointIndexForbidden = (cps, index) -> null != cps && index + 1 > ((ControlPoint[])cps).length;
    public static BiPredicate<ControlPoint[], ControlPoint[]> cannotControlPointsBeUpdated = (cps1, cps2) -> null != cps1 && null == cps2 || null == cps1 && null != cps2 || null == cps1 || ((ControlPoint[])cps1).length != ((ControlPoint[])cps2).length;

    public static void checkAddControlPoint(ControlPoint[] controlPoints, ControlPoint controlPoint, int index) {
        if (isControlPointIndexInvalid.test(index)) {
            throw new IllegalArgumentException("The given index [" + index + "] for the new CP is not valid.");
        }
        if (isAddingControlPointIndexForbidden.test(controlPoints, index)) {
            throw new IllegalArgumentException("Cannot add a new CP at the given index [" + index + "].");
        }
        if (isControlPointInvalid.test(controlPoint)) {
            throw new IllegalArgumentException("The given CP is not valid");
        }
    }

    public static void checkDeleteControlPoint(ControlPoint[] controlPoints, int index) {
        if (isControlPointIndexInvalid.test(index)) {
            throw new IllegalArgumentException("The given index [" + index + "] for the new CP is not valid.");
        }
        if (isDeletingControlPointIndexForbidden.test(controlPoints, index)) {
            throw new IllegalArgumentException("Cannot delete a new CP at the given index [" + index + "].");
        }
    }

    public static void checkUpdateControlPoint(ControlPoint[] controlPoints1, ControlPoint[] controlPoints2) {
        if (cannotControlPointsBeUpdated.test(controlPoints1, controlPoints2)) {
            throw new IllegalArgumentException("The control points cannot be updated, length differs [" + ControlPointValidations.length(controlPoints1) + ":" + ControlPointValidations.length(controlPoints2) + "].");
        }
    }

    private static int length(ControlPoint[] controlPoints) {
        return null != controlPoints ? controlPoints.length : 0;
    }
}

