/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.builder.ObservablePOMFile;
import org.guvnor.common.services.builder.ResourceChangeIncrementalBuilder;
import org.guvnor.common.services.builder.ResourceChangeObservableFile;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class ResourceChangeObserver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceChangeObserver.class);
    @Inject
    private ModuleService<? extends Module> projectService;
    @Inject
    private ResourceChangeIncrementalBuilder incrementalBuilder;
    @Inject
    private Event<InvalidateDMOModuleCacheEvent> invalidateDMOProjectCacheEvent;
    @Inject
    @Any
    private Instance<ResourceChangeObservableFile> observableFiles;
    @Inject
    private ObservablePOMFile observablePomFile;

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        this.processResourceChange(resourceAddedEvent.getSessionInfo(), resourceAddedEvent.getPath(), ResourceChangeType.ADD);
        this.incrementalBuilder.addResource(resourceAddedEvent.getPath());
    }

    public void processResourceDelete(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        this.processResourceChange(resourceDeletedEvent.getSessionInfo(), resourceDeletedEvent.getPath(), ResourceChangeType.DELETE);
        this.incrementalBuilder.deleteResource(resourceDeletedEvent.getPath());
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        this.processResourceChange(resourceUpdatedEvent.getSessionInfo(), resourceUpdatedEvent.getPath(), ResourceChangeType.UPDATE);
        this.incrementalBuilder.updateResource(resourceUpdatedEvent.getPath());
    }

    public void processResourceCopied(@Observes ResourceCopiedEvent resourceCopiedEvent) {
        this.processResourceChange(resourceCopiedEvent.getSessionInfo(), resourceCopiedEvent.getPath(), ResourceChangeType.COPY);
        this.incrementalBuilder.addResource(resourceCopiedEvent.getPath());
    }

    public void processResourceRenamed(@Observes ResourceRenamedEvent resourceRenamedEvent) {
        this.processResourceChange(resourceRenamedEvent.getSessionInfo(), resourceRenamedEvent.getPath(), ResourceChangeType.RENAME);
        this.incrementalBuilder.deleteResource(resourceRenamedEvent.getPath());
        this.incrementalBuilder.addResource(resourceRenamedEvent.getDestinationPath());
    }

    public void processBatchChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        Map batchChanges = resourceBatchChangesEvent.getBatch();
        if (batchChanges == null) {
            logger.warn("No batchChanges was present for the given resourceBatchChangesEvent: " + resourceBatchChangesEvent);
        } else {
            this.processBatchResourceChanges(resourceBatchChangesEvent.getSessionInfo(), batchChanges);
            this.incrementalBuilder.batchResourceChanges(resourceBatchChangesEvent.getBatch());
        }
    }

    private void processResourceChange(SessionInfo sessionInfo, Path path, ResourceChangeType changeType) {
        Module module = this.projectService.resolveModule(path);
        if (module == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processing resource change for sessionInfo: " + sessionInfo + ", project: " + module + ", path: " + path + ", changeType: " + changeType);
        }
        if (this.isObservableResource(path)) {
            this.invalidateDMOProjectCacheEvent.fire((Object)new InvalidateDMOModuleCacheEvent(sessionInfo, module, path));
        }
    }

    private void processBatchResourceChanges(SessionInfo sessionInfo, Map<Path, Collection<ResourceChange>> resourceChanges) {
        HashMap<Module, Path> pendingNotifications = new HashMap<Module, Path>();
        for (Map.Entry<Path, Collection<ResourceChange>> entry : resourceChanges.entrySet()) {
            Module module = this.projectService.resolveModule(entry.getKey());
            if (module == null) continue;
            if (!pendingNotifications.containsKey(module) && this.isObservableResource(entry.getKey())) {
                pendingNotifications.put(module, entry.getKey());
                continue;
            }
            if (!this.isPomFile(entry.getKey())) continue;
            pendingNotifications.put(module, entry.getKey());
        }
        for (Map.Entry<Object, Collection<Object>> entry : pendingNotifications.entrySet()) {
            this.invalidateDMOProjectCacheEvent.fire((Object)new InvalidateDMOModuleCacheEvent(sessionInfo, (Module)entry.getKey(), (Path)entry.getValue()));
        }
    }

    private boolean isObservableResource(Path path) {
        if (path == null) {
            return false;
        }
        for (ResourceChangeObservableFile observableFile : this.observableFiles) {
            if (!observableFile.accept(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isPomFile(Path path) {
        if (path == null) {
            return false;
        }
        return this.observablePomFile.accept(path);
    }
}

