/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan;

import org.apache.lucene.analysis.Analyzer;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanIndexProvider;
import org.uberfire.ext.metadata.backend.infinispan.search.InfinispanSearchIndex;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.ext.metadata.search.SearchIndex;

public class InfinispanSearchConfig
implements MetadataConfig {
    private final InfinispanIndexProvider indexProvider;
    private final InfinispanSearchIndex searchIndex;
    private MetaModelStore metaModelStore;
    private MetaIndexEngine metaIndexEngine;

    public InfinispanSearchConfig(MetaIndexEngine metaIndexEngine, InfinispanIndexProvider infinispanIndexProvider, MetaModelStore metaModelStore, Analyzer analyzer) {
        this.metaIndexEngine = metaIndexEngine;
        this.indexProvider = infinispanIndexProvider;
        this.searchIndex = new InfinispanSearchIndex(infinispanIndexProvider, analyzer);
        this.metaModelStore = metaModelStore;
    }

    public IndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.metaIndexEngine;
    }

    public MetaModelStore getMetaModelStore() {
        return this.metaModelStore;
    }

    public int priority() {
        return -20;
    }

    public void dispose() {
        this.indexProvider.dispose();
        this.metaIndexEngine.dispose();
    }
}

