/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.function.Consumer;
import javax.inject.Inject;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.RemoteDataSetDefBuilder;
import org.kie.server.api.model.definition.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSetDefsBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSetDefsBootstrap.class);
    @Inject
    DataSetDefRegistry dataSetDefRegistry;

    protected void registerDataSetDefinition(QueryDefinition queryDefinition, Consumer<RemoteDataSetDefBuilder> consumer) {
        RemoteDataSetDefBuilder builder = RemoteDataSetDefBuilder.get().uuid(queryDefinition.getName()).name(queryDefinition.getTarget() + "-" + queryDefinition.getName()).queryTarget(queryDefinition.getTarget()).dataSource(queryDefinition.getSource()).dbSQL(queryDefinition.getExpression(), false);
        consumer.accept(builder);
        DataSetDef dataSetDef = builder.buildDef();
        dataSetDef.setPublic(false);
        dataSetDef.setProvider(KieServerDataSetProvider.TYPE);
        this.dataSetDefRegistry.registerDataSetDef(dataSetDef);
        LOGGER.info("Data Set registered {}", (Object)dataSetDef);
    }
}

