/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.metrics.group;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataprovider.kafka.mbean.MBeanNameFactory;
import org.dashbuilder.dataprovider.kafka.mbean.ObjectNameBuilder;
import org.dashbuilder.dataprovider.kafka.mbean.ObjectNamePrototype;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.MBeanMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroup;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;

class ConsumerMetricsGroup
implements MetricsCollectorGroup {
    private static final ObjectNamePrototype KAFKA_CONSUMER = ObjectNamePrototype.withDomainAndType("kafka.consumer", "consumer-metrics");
    private static final ObjectNamePrototype KAFKA_CONSUMER_FETCH_MANAGER = ObjectNamePrototype.withDomainAndType("kafka.consumer", "producer-node-metrics");
    private static final ObjectNamePrototype KAFKA_CONSUMER_COORDINATOR = ObjectNamePrototype.withDomainAndType("kafka.consumer", "consumer-coordinator-metrics");
    private static final ObjectNamePrototype KAFKA_CONSUMER_NODE = ObjectNamePrototype.withDomainAndType("kafka.consumer", "consumer-node-metrics");
    private static final ObjectNamePrototype KAFKA_CONSUMER_TOPIC_FETCH_MANAGER = ObjectNamePrototype.withDomainAndType("kafka.consumer", "consumer-fetch-manager-metrics");

    ConsumerMetricsGroup() {
    }

    @Override
    public List<KafkaMetricCollector> getMetricsCollectors(KafkaMetricsRequest request) {
        String clientId = request.clientId().orElseThrow(() -> new IllegalArgumentException("Client Id is required to retrieve consumer metrics."));
        if (request.nodeId().isPresent()) {
            String mbean = KAFKA_CONSUMER_NODE.copy().hyfenClientId(clientId).hyfenNodeId(request.nodeId().get()).build();
            return Collections.singletonList(MBeanMetricCollector.metricCollector(mbean));
        }
        if (request.topic().isPresent()) {
            ObjectNameBuilder mbeanBuilder = KAFKA_CONSUMER_TOPIC_FETCH_MANAGER.copy().hyfenClientId(clientId).topic(request.topic().get());
            request.partition().ifPresent(mbeanBuilder::partition);
            return Collections.singletonList(MBeanMetricCollector.metricCollector(mbeanBuilder.build()));
        }
        return Arrays.asList(MBeanMetricCollector.metricCollector(MBeanNameFactory.withProducerConsumerClientId(KAFKA_CONSUMER, clientId)), MBeanMetricCollector.metricCollector(MBeanNameFactory.withProducerConsumerClientId(KAFKA_CONSUMER_FETCH_MANAGER, clientId)), MBeanMetricCollector.metricCollector(MBeanNameFactory.withProducerConsumerClientId(KAFKA_CONSUMER_COORDINATOR, clientId)));
    }
}

