/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.DocumentUploadSession;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.UploadedDocumentStorage;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.DocumentUploadChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class UploadedDocumentStorageImpl
implements UploadedDocumentStorage,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(UploadedDocumentStorageImpl.class);
    public static final String UPLOADS_FOLDER = "uploads";
    public static final String PARTS_FOLDER = "parts";
    public static final String PART_EXTENSION = ".part";
    protected Path rootFolder;
    private Map<String, File> uploadedFiles = new HashMap<String, File>();

    @PostConstruct
    public void init() {
        try {
            this.rootFolder = Files.createTempDirectory(UPLOADS_FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warn("Cannot create tmp folder for document uploading due to: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void uploadContentChunk(DocumentUploadChunk chunk) throws Exception {
        File docFolder = this.resolveDocStorage(chunk.getDocumentId());
        File chunkFile = docFolder.toPath().resolve(PARTS_FOLDER).resolve(this.resolveChunkFileName(chunk)).toFile();
        FileUtils.writeByteArrayToFile((File)chunkFile, (byte[])Base64.getDecoder().decode(chunk.getContent()));
        chunk.clearContent();
    }

    @Override
    public void merge(DocumentUploadSession session) {
        try {
            File destination = this.doMerge(session);
            if (session.getState().equals((Object)DocumentUploadSession.State.MERGED)) {
                this.uploadedFiles.put(session.getDocumentId(), destination);
            }
        }
        catch (Exception ex) {
            logger.warn("Cannot merge document {}: {}", (Object)session.getDocumentName(), (Object)ex);
            throw new RuntimeException("Cannot merge document " + session.getDocumentName());
        }
    }

    private File doMerge(DocumentUploadSession session) throws Exception {
        File docFolder = this.resolveDocStorage(session.getDocumentId());
        File destination = docFolder.toPath().resolve(session.getDocumentName()).toFile();
        if (destination.exists()) {
            destination.delete();
        }
        destination.createNewFile();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destination));){
            for (DocumentUploadChunk chunk : session.getChunks()) {
                if (!session.getState().equals((Object)DocumentUploadSession.State.MERGING)) {
                    File file = null;
                    return file;
                }
                IOUtils.copy((InputStream)new FileInputStream(this.resolveChunkFile(chunk)), (OutputStream)out);
            }
            FileUtils.deleteQuietly((File)docFolder.toPath().resolve(PARTS_FOLDER).toFile());
        }
        session.setState(DocumentUploadSession.State.MERGED);
        return destination;
    }

    private File resolveChunkFile(DocumentUploadChunk chunk) {
        File docFolder = this.resolveDocStorage(chunk.getDocumentId());
        return docFolder.toPath().resolve(PARTS_FOLDER).resolve(this.resolveChunkFileName(chunk)).toFile();
    }

    private String resolveChunkFileName(DocumentUploadChunk chunk) {
        return chunk.getDocumentId() + "_" + chunk.getIndex() + PART_EXTENSION;
    }

    private File resolveDocStorage(String documentId) {
        Path docPath = this.rootFolder.resolve(documentId);
        File file = docPath.toFile();
        if (!file.exists()) {
            try {
                return Files.createDirectory(docPath, new FileAttribute[0]).toFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    @Override
    public void uploadContent(String id, byte[] content) {
        File file = this.rootFolder.resolve(id).toFile();
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])content);
        }
        catch (IOException ex) {
            logger.warn("Cannot upload content for document {}: {}", (Object)id, (Object)ex);
        }
        this.uploadedFiles.put(id, file);
    }

    @Override
    public byte[] getContent(String id) {
        File file = this.uploadedFiles.get(id);
        if (file != null) {
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException ex) {
                logger.warn("Cannot read content for document {}: {}", (Object)id, (Object)ex);
            }
        }
        return new byte[0];
    }

    @Override
    public void removeContent(String id) {
        File file = this.uploadedFiles.remove(id);
        if (file != null) {
            FileUtils.deleteQuietly((File)file.getParentFile());
        } else {
            FileUtils.deleteQuietly((File)this.resolveDocStorage(id));
        }
    }

    @Override
    public void clear() {
        this.uploadedFiles.clear();
        FileUtils.deleteQuietly((File)this.rootFolder.toFile());
    }
}

