/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.ThrowEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events.IntermediateLinkEventPostConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class IntermediateLinkEventPostConverterTest {
    @Mock
    private ProcessPropertyWriter processWriter;
    @Mock
    private BasePropertyWriter nodeWriter;
    @Mock
    private Node<View<? extends BPMNViewDefinition>, ?> node;
    @Mock
    private ThrowEvent throwLinkEvent;
    @Mock
    private CatchEvent catchLinkEvent;
    @Mock
    private CatchEvent catchSignalEvent;
    @Mock
    private LinkEventDefinition throwDefinition;
    @Mock
    private LinkEventDefinition catchDefinition;
    @Mock
    private Process process;
    private static final String EVENT_ID = "EVENT_ID";
    private static final String LINK_NAME = "LINK_NAME";
    private IntermediateLinkEventPostConverter converter = (IntermediateLinkEventPostConverter)Mockito.spy((Object)new IntermediateLinkEventPostConverter());
    private final List<EventDefinition> throwDefinitions = new ArrayList<EventDefinition>();
    private final List<EventDefinition> catchDefinitions = new ArrayList<EventDefinition>();
    private final List<FlowElement> elementsInTopLevel = new ArrayList<FlowElement>();

    @Before
    public void init() {
        Mockito.when((Object)this.nodeWriter.getElement()).thenReturn((Object)this.throwLinkEvent);
        Mockito.when((Object)this.throwLinkEvent.getId()).thenReturn((Object)EVENT_ID);
        Mockito.when((Object)this.processWriter.getProcess()).thenReturn((Object)this.process);
        Mockito.when((Object)this.throwDefinition.getName()).thenReturn((Object)LINK_NAME);
        this.throwDefinitions.add((EventDefinition)this.throwDefinition);
        Mockito.when((Object)this.throwLinkEvent.getEventDefinitions()).thenReturn(this.throwDefinitions);
        Mockito.when((Object)this.catchDefinition.getName()).thenReturn((Object)LINK_NAME);
        this.catchDefinitions.add((EventDefinition)this.catchDefinition);
        Mockito.when((Object)this.catchLinkEvent.getEventDefinitions()).thenReturn(this.catchDefinitions);
        ArrayList<Object> signalDefinitions = new ArrayList<Object>();
        signalDefinitions.add(Mockito.mock(EventDefinition.class));
        Mockito.when((Object)this.catchSignalEvent.getEventDefinitions()).thenReturn(signalDefinitions);
        this.elementsInTopLevel.add((FlowElement)Mockito.mock(StartEvent.class));
        this.elementsInTopLevel.add((FlowElement)Mockito.mock(EndEvent.class));
        this.elementsInTopLevel.add((FlowElement)this.throwLinkEvent);
        this.elementsInTopLevel.add((FlowElement)this.catchSignalEvent);
        this.elementsInTopLevel.add((FlowElement)this.catchLinkEvent);
        Mockito.when((Object)this.process.getFlowElements()).thenReturn(this.elementsInTopLevel);
    }

    @Test
    public void testNullEventDefinitions() {
        Mockito.when((Object)this.throwLinkEvent.getEventDefinitions()).thenReturn(null);
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter, (VerificationMode)Mockito.never())).addTargetRef((Process)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (LinkEventDefinition)ArgumentMatchers.any());
    }

    @Test
    public void testEmptyEventDefinitions() {
        Mockito.when((Object)this.throwLinkEvent.getEventDefinitions()).thenReturn(Collections.emptyList());
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter, (VerificationMode)Mockito.never())).addTargetRef((Process)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (LinkEventDefinition)ArgumentMatchers.any());
    }

    @Test
    public void testEmptyLinkName() {
        Mockito.when((Object)this.throwDefinition.getName()).thenReturn(null);
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter, (VerificationMode)Mockito.never())).findTarget((FlowElementsContainer)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testNoTargetsForEmptyGraph() {
        Mockito.when((Object)this.process.getFlowElements()).thenReturn(Collections.emptyList());
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).findTarget((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)EVENT_ID), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((LinkEventDefinition)Mockito.verify((Object)this.throwDefinition, (VerificationMode)Mockito.never())).setTarget((LinkEventDefinition)ArgumentMatchers.any());
    }

    @Test
    public void testThrowEventWithoutCatchEvent() {
        this.elementsInTopLevel.remove(this.catchLinkEvent);
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).findTarget((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)EVENT_ID), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).getCatchLinkEventWithSameName((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((LinkEventDefinition)Mockito.verify((Object)this.throwDefinition, (VerificationMode)Mockito.never())).setTarget((LinkEventDefinition)ArgumentMatchers.any());
    }

    @Test
    public void testThrowEventWithoutCatchEventDefinitions() {
        Mockito.when((Object)this.catchLinkEvent.getEventDefinitions()).thenReturn(Collections.emptyList());
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).findTarget((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)EVENT_ID), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).getCatchLinkEventWithSameName((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((LinkEventDefinition)Mockito.verify((Object)this.throwDefinition, (VerificationMode)Mockito.never())).setTarget((LinkEventDefinition)ArgumentMatchers.any());
    }

    @Test
    public void testThrowEventCatchEventOnTheTopLevel() {
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).findTarget((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)EVENT_ID), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((IntermediateLinkEventPostConverter)Mockito.verify((Object)this.converter)).getCatchLinkEventWithSameName((FlowElementsContainer)ArgumentMatchers.eq((Object)this.process), (String)ArgumentMatchers.eq((Object)LINK_NAME));
        ((LinkEventDefinition)Mockito.verify((Object)this.throwDefinition)).setTarget(this.catchDefinition);
    }
}

