/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.associations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.associations.AssociationConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssociationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.Association;
import org.kie.workbench.common.stunner.bpmn.definition.DirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.NonDirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssociationConverterTest {
    private static final String ASSOCIATION_ID = "ASSOCIATION_ID";
    private static final String ASSOCIATION_DOCUMENTATION = "ASSOCIATION_DOCUMENTATION";
    private static final String SOURCE_ID = "SOURCE_ID";
    private static final String TARGET_ID = "TARGET_ID";
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    @Mock
    private TypedFactoryManager factoryManager;
    @Mock
    private Edge<View<Association>, Node> edge;
    @Mock
    private View<Association> content;
    @Mock
    private Association definition;
    @Captor
    private ArgumentCaptor<BPMNGeneralSet> generalSetCaptor;
    @Mock
    private org.eclipse.bpmn2.Association association;
    @Mock
    private AssociationPropertyReader associationReader;
    private AssociationConverter associationConverter;
    private Map<String, BpmnNode> nodes;
    @Mock
    private BpmnNode sourceNode;
    @Mock
    private BpmnNode targetNode;
    @Mock
    private Connection sourceConnection;
    @Mock
    private Connection targetConnection;
    @Mock
    private List<Point2D> controlPoints;
    @Mock
    private Edge<View<NonDirectionalAssociation>, Node> edgeNonDirectional;
    @Mock
    private View<NonDirectionalAssociation> contentNonDirectional;
    @Mock
    private NonDirectionalAssociation definitionNonDirectional;

    @Before
    public void setUp() {
        Mockito.when((Object)this.association.getId()).thenReturn((Object)ASSOCIATION_ID);
        Mockito.when((Object)this.edge.getContent()).thenReturn(this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.factoryManager.newEdge(ASSOCIATION_ID, DirectionalAssociation.class)).thenReturn(this.edge);
        Mockito.when((Object)this.propertyReaderFactory.of(this.association)).thenReturn((Object)this.associationReader);
        Mockito.when((Object)this.associationReader.getAssociationByDirection()).thenAnswer(a -> DirectionalAssociation.class);
        Mockito.when((Object)this.associationReader.getDocumentation()).thenReturn((Object)ASSOCIATION_DOCUMENTATION);
        Mockito.when((Object)this.associationReader.getSourceId()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.associationReader.getTargetId()).thenReturn((Object)TARGET_ID);
        Mockito.when((Object)this.associationReader.getSourceConnection()).thenReturn((Object)this.sourceConnection);
        Mockito.when((Object)this.associationReader.getTargetConnection()).thenReturn((Object)this.targetConnection);
        Mockito.when((Object)this.associationReader.getControlPoints()).thenReturn(this.controlPoints);
        this.associationConverter = new AssociationConverter(this.factoryManager, this.propertyReaderFactory);
        this.nodes = new HashMap<String, BpmnNode>();
        this.nodes.put(SOURCE_ID, this.sourceNode);
        this.nodes.put(TARGET_ID, this.targetNode);
    }

    @Test
    public void testConvertEdge() {
        this.associationConverter.convertEdge(this.association, this.nodes);
        ((Association)Mockito.verify((Object)this.definition)).setGeneral((BPMNGeneralSet)this.generalSetCaptor.capture());
        Assert.assertEquals((Object)ASSOCIATION_DOCUMENTATION, (Object)((BPMNGeneralSet)this.generalSetCaptor.getValue()).getDocumentation().getValue());
        this.assertEdgeWithConnections();
    }

    private void assertEdgeWithConnections() {
        BpmnEdge.Simple result = (BpmnEdge.Simple)this.associationConverter.convertEdge(this.association, this.nodes).value();
        Assert.assertEquals((Object)this.sourceNode, (Object)result.getSource());
        Assert.assertEquals((Object)this.targetNode, (Object)result.getTarget());
        Assert.assertEquals((Object)this.sourceConnection, (Object)result.getSourceConnection());
        Assert.assertEquals((Object)this.targetConnection, (Object)result.getTargetConnection());
        Assert.assertEquals(this.controlPoints, (Object)result.getControlPoints());
        Assert.assertEquals(this.edge, (Object)result.getEdge());
    }

    @Test
    public void testConvertEdgeNonDirectional() {
        Mockito.when((Object)this.factoryManager.newEdge(ASSOCIATION_ID, NonDirectionalAssociation.class)).thenReturn(this.edgeNonDirectional);
        Mockito.when((Object)this.associationReader.getAssociationByDirection()).thenAnswer(a -> NonDirectionalAssociation.class);
        Mockito.when((Object)this.edgeNonDirectional.getContent()).thenReturn(this.contentNonDirectional);
        Mockito.when((Object)this.contentNonDirectional.getDefinition()).thenReturn((Object)this.definitionNonDirectional);
        BpmnEdge.Simple result = (BpmnEdge.Simple)this.associationConverter.convertEdge(this.association, this.nodes).value();
        Assert.assertEquals(this.edgeNonDirectional, (Object)result.getEdge());
    }

    @Test
    public void testConvertIgnoredEdge() {
        this.assertEdgeWithConnections();
        this.nodes.remove(SOURCE_ID);
        BpmnEdge.Simple result = (BpmnEdge.Simple)this.associationConverter.convertEdge(this.association, this.nodes).value();
        Assert.assertNull((Object)result);
        this.nodes.put(SOURCE_ID, this.sourceNode);
        this.nodes.remove(TARGET_ID);
        result = (BpmnEdge.Simple)this.associationConverter.convertEdge(this.association, this.nodes).value();
        Assert.assertNull((Object)result);
        this.nodes.put(SOURCE_ID, this.sourceNode);
        this.nodes.put(TARGET_ID, this.targetNode);
        this.assertEdgeWithConnections();
    }
}

