/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.AbstractDefinitionManager;
import org.kie.workbench.common.stunner.core.definition.DefinitionSetProxy;
import org.kie.workbench.common.stunner.core.definition.adapter.Adapter;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;

@ApplicationScoped
public class BackendDefinitionManager
extends AbstractDefinitionManager {
    private final Instance<DefinitionSetProxy<?>> definitionSetsInstances;
    private final Instance<DefinitionSetAdapter<?>> definitionSetAdapterInstances;
    private final Instance<DefinitionSetRuleAdapter<?>> definitionSetRuleAdapterInstances;
    private final Instance<DefinitionAdapter<?>> definitionAdapterInstances;
    private final Instance<PropertyAdapter<?, ?>> propertyAdapterInstances;
    private final Instance<MorphAdapter<?>> morphAdapterInstances;

    protected BackendDefinitionManager() {
        this.definitionSetsInstances = null;
        this.definitionSetAdapterInstances = null;
        this.definitionSetRuleAdapterInstances = null;
        this.definitionAdapterInstances = null;
        this.propertyAdapterInstances = null;
        this.morphAdapterInstances = null;
    }

    @Inject
    public BackendDefinitionManager(RegistryFactory registryFactory, AdapterManager adapterManager, Instance<DefinitionSetProxy<?>> definitionSetsInstances, Instance<DefinitionSetAdapter<?>> definitionSetAdapterInstances, Instance<DefinitionSetRuleAdapter<?>> definitionSetRuleAdapterInstances, Instance<DefinitionAdapter<?>> definitionAdapterInstances, Instance<PropertyAdapter<?, ?>> propertyAdapterInstances, Instance<MorphAdapter<?>> morphAdapterInstances, CloneManager cloneManager) {
        super(registryFactory, adapterManager, cloneManager);
        this.definitionSetsInstances = definitionSetsInstances;
        this.definitionSetAdapterInstances = definitionSetAdapterInstances;
        this.definitionSetRuleAdapterInstances = definitionSetRuleAdapterInstances;
        this.definitionAdapterInstances = definitionAdapterInstances;
        this.propertyAdapterInstances = propertyAdapterInstances;
        this.morphAdapterInstances = morphAdapterInstances;
    }

    @PostConstruct
    public void init() {
        this.initAdapters();
        this.initMorphAdapters();
        this.initDefSets();
    }

    private void initDefSets() {
        for (DefinitionSetProxy definitionSet : this.definitionSetsInstances) {
            this.addDefinitionSet(definitionSet.getDefinitionSet());
        }
    }

    private void initAdapters() {
        for (DefinitionSetAdapter definitionSetAdapter : this.definitionSetAdapterInstances) {
            this.addAdapter((Adapter)definitionSetAdapter);
        }
        for (DefinitionSetRuleAdapter definitionSetRuleAdapter : this.definitionSetRuleAdapterInstances) {
            this.addAdapter((Adapter)definitionSetRuleAdapter);
        }
        for (DefinitionAdapter definitionAdapter : this.definitionAdapterInstances) {
            this.addAdapter((Adapter)definitionAdapter);
        }
        for (PropertyAdapter propertyAdapter : this.propertyAdapterInstances) {
            this.addAdapter((Adapter)propertyAdapter);
        }
    }

    private void initMorphAdapters() {
        for (MorphAdapter morphAdapter : this.morphAdapterInstances) {
            this.addAdapter((Adapter)morphAdapter);
        }
    }
}

